% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mipplot_line.R
\name{mipplot_line}
\alias{mipplot_line}
\title{Line plot from IAMC data}
\usage{
mipplot_line(
  D,
  region = levels(D$region),
  variable = levels(D$variable),
  colorby = "scenario",
  linetypeby = "model",
  shapeby = "model",
  scenario = levels(D$scenario),
  facet_x = NULL,
  facet_y = NULL,
  legend = TRUE,
  PRINT_OUT = FALSE,
  DEBUG = TRUE,
  axis_year_text_angle = 0,
  language = "en",
  max_scenarios = 15,
  max_models = 15
)
}
\arguments{
\item{D}{A dataframe of IAMC data in tibble format to produce plots.}

\item{region}{A list of regions.}

\item{variable}{A list of variables.}

\item{colorby}{an axis for color setting.}

\item{linetypeby}{an axis for line type setting.}

\item{shapeby}{an axis for shape setting.}

\item{scenario}{A list of scenarios.}

\item{facet_x}{facet_x}

\item{facet_y}{facet_y}

\item{legend}{set TRUE to plot legend. default is TRUE.}

\item{PRINT_OUT}{set TRUE to generate PDF files.}

\item{DEBUG}{set TRUE to show debug messages.}

\item{axis_year_text_angle}{text angle of x axis}

\item{language}{A string of language. Possible values are "en", "jp",
"es", "zh-cn", "zh-tw". The default value is "en".}

\item{max_scenarios}{Maximum number of scenarios to be shown. If legend is FALSE, this option is .}

\item{max_models}{Maximum number of models to be shown. If legend is FALSE, this option is}
}
\value{
A list of line plots.
}
\description{
The function arguments include the input dataframe,
             labels for the plot/axes/legend, and faceting dimensions
}
\examples{
\donttest{
library(dplyr)
data_subset <- ar5_db_sample_data \%>\%
filter( model \%in\% c("AIM-Enduse 12.1", "GCAM 3.0", "IMAGE 2.4") ) \%>\%
filter(2005 <= period) \%>\%
filter(period <= 2100)
mipplot_line(
data_subset,
variable = c("Emissions|CO2"),
scenario = c("EMF27-450-Conv", "EMF27-450-FullTech", "EMF27-450-NoCCS"),
region = c("ASIA"),
legend = TRUE,
axis_year_text_angle = 0,
language = 'en')
}
}
