% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mipplot_additivity_check.R
\name{mipplot_additivity_check}
\alias{mipplot_additivity_check}
\title{check additivity of rules and data}
\usage{
mipplot_additivity_check(D, R, max_n_plots = Inf, plot_all = FALSE)
}
\arguments{
\item{D}{A dataframe of IAMC data in tibble format to produce area plots.}

\item{R}{A dataframe of data aggregation rules (meta data).}

\item{max_n_plots}{The maximum number of output plots.}

\item{plot_all}{set FALSE to plot only inconsistent combinations}
}
\value{
A list of area plots.
}
\description{
This function is used for debugging a rule table and data-set.
An input is a rule table and a data-set, the outputs are some area plots
showing the divergence between the left-side variable and
the sum of the right-side variables.
}
\examples{
\donttest{
if (interactive()) {
  mipplot_additivity_check(
    ar5_db_sample_data, ar5_db_sample_rule_table, max_n_plots = 10)
  }
}
}
