// Generated by rstantools.  Do not edit by hand.

/*
    miniLNM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    miniLNM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with miniLNM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_lnm_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 52> locations_array__ =
  {" (found before start of program)",
  " (in 'lnm', line 44, column 4 to column 22)",
  " (in 'lnm', line 45, column 4 to column 20)",
  " (in 'lnm', line 46, column 4 to column 33)",
  " (in 'lnm', line 50, column 4 to column 45)",
  " (in 'lnm', line 51, column 4 to column 46)",
  " (in 'lnm', line 53, column 4 to column 48)",
  " (in 'lnm', line 54, column 4 to column 30)",
  " (in 'lnm', line 34, column 4 to column 19)",
  " (in 'lnm', line 35, column 4 to column 19)",
  " (in 'lnm', line 36, column 4 to column 19)",
  " (in 'lnm', line 37, column 10 to column 11)",
  " (in 'lnm', line 37, column 13 to column 18)",
  " (in 'lnm', line 37, column 4 to column 35)",
  " (in 'lnm', line 38, column 11 to column 12)",
  " (in 'lnm', line 38, column 14 to column 15)",
  " (in 'lnm', line 38, column 4 to column 19)",
  " (in 'lnm', line 39, column 4 to column 17)",
  " (in 'lnm', line 40, column 4 to column 12)",
  " (in 'lnm', line 41, column 4 to column 12)",
  " (in 'lnm', line 44, column 11 to column 12)",
  " (in 'lnm', line 44, column 14 to column 15)",
  " (in 'lnm', line 45, column 11 to column 12)",
  " (in 'lnm', line 45, column 14 to column 15)",
  " (in 'lnm', line 46, column 20 to column 21)",
  " (in 'lnm', line 5, column 12 to column 41)",
  " (in 'lnm', line 4, column 27 to line 6, column 13)",
  " (in 'lnm', line 4, column 12 to line 6, column 13)",
  " (in 'lnm', line 3, column 23 to line 7, column 9)",
  " (in 'lnm', line 3, column 8 to line 7, column 9)",
  " (in 'lnm', line 2, column 72 to line 8, column 5)",
  " (in 'lnm', line 11, column 12 to column 37)",
  " (in 'lnm', line 10, column 23 to line 12, column 9)",
  " (in 'lnm', line 10, column 8 to line 12, column 9)",
  " (in 'lnm', line 9, column 64 to line 13, column 5)",
  " (in 'lnm', line 17, column 12 to column 62)",
  " (in 'lnm', line 16, column 27 to line 18, column 13)",
  " (in 'lnm', line 16, column 12 to line 18, column 13)",
  " (in 'lnm', line 15, column 23 to line 19, column 9)",
  " (in 'lnm', line 15, column 8 to line 19, column 9)",
  " (in 'lnm', line 14, column 86 to line 20, column 5)",
  " (in 'lnm', line 22, column 15 to column 20)",
  " (in 'lnm', line 22, column 8 to column 24)",
  " (in 'lnm', line 24, column 12 to column 31)",
  " (in 'lnm', line 25, column 12 to column 45)",
  " (in 'lnm', line 23, column 23 to line 26, column 9)",
  " (in 'lnm', line 23, column 8 to line 26, column 9)",
  " (in 'lnm', line 21, column 63 to line 27, column 5)",
  " (in 'lnm', line 29, column 15 to column 35)",
  " (in 'lnm', line 29, column 8 to column 64)",
  " (in 'lnm', line 30, column 8 to column 28)",
  " (in 'lnm', line 28, column 34 to line 31, column 5)"};
template <bool propto__, typename T0__, typename T3__, typename T4__,
          typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
void
matrix_normal_lp(const T0__& x_arg__, const int& N, const int& M, const T3__&
                 mu, const T4__& sigma2, T_lp__& lp__, T_lp_accum__&
                 lp_accum__, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T2__, typename T3__,
          typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>* = nullptr>
void
vector_inv_gamma_lp(const T0__& x_arg__, const int& D, const T2__& l1,
                    const T3__& l2, T_lp__& lp__, T_lp_accum__& lp_accum__,
                    std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T5__, typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_col_vector<T5__>,
                              stan::is_vt_not_complex<T5__>>* = nullptr>
void
outcome_mu_lp(const T0__& mu_arg__, const T1__& x_arg__, const T2__& B_arg__,
              const int& N, const int& K, const T5__& sigmas_mu_arg__,
              T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__);
template <bool propto__, typename T2__, typename T_lp__,
          typename T_lp_accum__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
void
outcome_y_lp(const std::vector<std::vector<int>>& y, const int& N,
             const T2__& mu_arg__, const int& K, T_lp__& lp__, T_lp_accum__&
             lp_accum__, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_row_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
phi_inv(const T0__& mu_arg__, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T3__, typename T4__,
          typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>*>
void
matrix_normal_lp(const T0__& x_arg__, const int& N, const int& M, const T3__&
                 mu, const T4__& sigma2, T_lp__& lp__, T_lp_accum__&
                 lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T3__, T4__>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 29;
    for (int n = 1; n <= N; ++n) {
      current_statement__ = 27;
      for (int m = 1; m <= M; ++m) {
        current_statement__ = 25;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::model::rvalue(x, "x",
                           stan::model::index_uni(n),
                           stan::model::index_uni(m)), mu, sigma2));
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T2__, typename T3__,
          typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>*>
void
vector_inv_gamma_lp(const T0__& x_arg__, const int& D, const T2__& l1,
                    const T3__& l2, T_lp__& lp__, T_lp_accum__& lp_accum__,
                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T2__, T3__>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 33;
    for (int d = 1; d <= D; ++d) {
      current_statement__ = 31;
      lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(
                       stan::model::rvalue(x, "x", stan::model::index_uni(d)),
                       l1, l2));
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T5__, typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_col_vector<T5__>,
                              stan::is_vt_not_complex<T5__>>*>
void
outcome_mu_lp(const T0__& mu_arg__, const T1__& x_arg__, const T2__& B_arg__,
              const int& N, const int& K, const T5__& sigmas_mu_arg__,
              T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>,
                             stan::base_type_t<T5__>>;
  int current_statement__ = 0;
  const auto& mu = stan::math::to_ref(mu_arg__);
  const auto& x = stan::math::to_ref(x_arg__);
  const auto& B = stan::math::to_ref(B_arg__);
  const auto& sigmas_mu = stan::math::to_ref(sigmas_mu_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 39;
    for (int i = 1; i <= N; ++i) {
      current_statement__ = 37;
      for (int k = 1; k <= K; ++k) {
        current_statement__ = 35;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::model::rvalue(mu, "mu",
                           stan::model::index_uni(i),
                           stan::model::index_uni(k)),
                         stan::math::multiply(
                           stan::model::rvalue(x, "x",
                             stan::model::index_uni(i)),
                           stan::math::col(B, k)),
                         stan::model::rvalue(sigmas_mu, "sigmas_mu",
                           stan::model::index_uni(k))));
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T2__, typename T_lp__,
          typename T_lp_accum__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
void
outcome_y_lp(const std::vector<std::vector<int>>& y, const int& N,
             const T2__& mu_arg__, const int& K, T_lp__& lp__, T_lp_accum__&
             lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& mu = stan::math::to_ref(mu_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 41;
    stan::math::validate_non_negative_index("p", "K + 1", (K + 1));
    Eigen::Matrix<local_scalar_t__,-1,1> p =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant((K + 1), DUMMY_VAR__);
    current_statement__ = 46;
    for (int i = 1; i <= N; ++i) {
      current_statement__ = 43;
      stan::model::assign(p,
        phi_inv(stan::model::rvalue(mu, "mu", stan::model::index_uni(i)),
          pstream__), "assigning variable p");
      current_statement__ = 44;
      lp_accum__.add(stan::math::multinomial_lpmf<propto__>(
                       stan::model::rvalue(y, "y", stan::model::index_uni(i)),
                       stan::math::to_vector(p)));
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_row_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
phi_inv(const T0__& mu_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& mu = stan::math::to_ref(mu_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 48;
    stan::math::validate_non_negative_index("mu_", "1 + num_elements(mu)", (1
      + stan::math::num_elements(mu)));
    Eigen::Matrix<local_scalar_t__,-1,1> mu_ =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant((1 +
        stan::math::num_elements(mu)), DUMMY_VAR__);
    current_statement__ = 49;
    stan::model::assign(mu_,
      stan::math::append_row(0.0, stan::math::transpose(mu)),
      "assigning variable mu_");
    current_statement__ = 50;
    return stan::math::softmax(mu_);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_lnm final : public model_base_crtp<model_lnm> {
private:
  int N;
  int K;
  int D;
  std::vector<std::vector<int>> y;
  Eigen::Matrix<double,-1,-1> x_data__;
  double sigma_b;
  double l1;
  double l2;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> x{nullptr, 0, 0};
public:
  ~model_lnm() {}
  model_lnm(stan::io::var_context& context__, unsigned int random_seed__ = 0,
            std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_lnm_namespace::model_lnm";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 8;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 8;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 9;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 9;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 9;
      stan::math::check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 10;
      context__.validate_dims("data initialization", "D", "int",
        std::vector<size_t>{});
      D = std::numeric_limits<int>::min();
      current_statement__ = 10;
      D = context__.vals_i("D")[(1 - 1)];
      current_statement__ = 10;
      stan::math::check_greater_or_equal(function__, "D", D, 1);
      current_statement__ = 11;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 12;
      stan::math::validate_non_negative_index("y", "K + 1", (K + 1));
      current_statement__ = 13;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(N),
          static_cast<size_t>((K + 1))});
      y = std::vector<std::vector<int>>(N,
            std::vector<int>((K + 1), std::numeric_limits<int>::min()));
      {
        std::vector<int> y_flat__;
        current_statement__ = 13;
        y_flat__ = context__.vals_i("y");
        current_statement__ = 13;
        pos__ = 1;
        current_statement__ = 13;
        for (int sym1__ = 1; sym1__ <= (K + 1); ++sym1__) {
          current_statement__ = 13;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 13;
            stan::model::assign(y, y_flat__[(pos__ - 1)],
              "assigning variable y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 13;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 13;
      stan::math::check_greater_or_equal(function__, "y", y, 0);
      current_statement__ = 14;
      stan::math::validate_non_negative_index("x", "N", N);
      current_statement__ = 15;
      stan::math::validate_non_negative_index("x", "D", D);
      current_statement__ = 16;
      context__.validate_dims("data initialization", "x", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(D)});
      x_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, D,
                   std::numeric_limits<double>::quiet_NaN());
      new (&x) Eigen::Map<Eigen::Matrix<double,-1,-1>>(x_data__.data(), N, D);
      {
        std::vector<local_scalar_t__> x_flat__;
        current_statement__ = 16;
        x_flat__ = context__.vals_r("x");
        current_statement__ = 16;
        pos__ = 1;
        current_statement__ = 16;
        for (int sym1__ = 1; sym1__ <= D; ++sym1__) {
          current_statement__ = 16;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 16;
            stan::model::assign(x, x_flat__[(pos__ - 1)],
              "assigning variable x", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 16;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 17;
      context__.validate_dims("data initialization", "sigma_b", "double",
        std::vector<size_t>{});
      sigma_b = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 17;
      sigma_b = context__.vals_r("sigma_b")[(1 - 1)];
      current_statement__ = 18;
      context__.validate_dims("data initialization", "l1", "double",
        std::vector<size_t>{});
      l1 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 18;
      l1 = context__.vals_r("l1")[(1 - 1)];
      current_statement__ = 19;
      context__.validate_dims("data initialization", "l2", "double",
        std::vector<size_t>{});
      l2 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 19;
      l2 = context__.vals_r("l2")[(1 - 1)];
      current_statement__ = 20;
      stan::math::validate_non_negative_index("beta", "D", D);
      current_statement__ = 21;
      stan::math::validate_non_negative_index("beta", "K", K);
      current_statement__ = 22;
      stan::math::validate_non_negative_index("mu", "N", N);
      current_statement__ = 23;
      stan::math::validate_non_negative_index("mu", "K", K);
      current_statement__ = 24;
      stan::math::validate_non_negative_index("sigmas_mu", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = (D * K) + (N * K) + K;
  }
  inline std::string model_name() const final {
    return "model_lnm";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ = "model_lnm_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,-1> beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(D, K, DUMMY_VAR__);
      current_statement__ = 1;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(D, K);
      Eigen::Matrix<local_scalar_t__,-1,-1> mu =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, K, DUMMY_VAR__);
      current_statement__ = 2;
      mu = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(N, K);
      Eigen::Matrix<local_scalar_t__,-1,1> sigmas_mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 3;
      sigmas_mu = in__.template read_constrain_lb<
                    Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                    lp__, K);
      {
        current_statement__ = 4;
        matrix_normal_lp<propto__>(beta, D, K, static_cast<double>(0),
          sigma_b, lp__, lp_accum__, pstream__);
        current_statement__ = 5;
        vector_inv_gamma_lp<propto__>(sigmas_mu, K, l1, l2, lp__, lp_accum__,
          pstream__);
        current_statement__ = 6;
        outcome_mu_lp<propto__>(mu, x, beta, N, K, sigmas_mu, lp__,
          lp_accum__, pstream__);
        current_statement__ = 7;
        outcome_y_lp<propto__>(y, N, mu, K, lp__, lp_accum__, pstream__);
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_lnm_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,-1> beta =
        Eigen::Matrix<double,-1,-1>::Constant(D, K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(D, K);
      Eigen::Matrix<double,-1,-1> mu =
        Eigen::Matrix<double,-1,-1>::Constant(N, K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      mu = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(N, K);
      Eigen::Matrix<double,-1,1> sigmas_mu =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      sigmas_mu = in__.template read_constrain_lb<
                    Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                    lp__, K);
      out__.write(beta);
      out__.write(mu);
      out__.write(sigmas_mu);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,-1> beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(D, K, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(D, K),
        "assigning variable beta");
      out__.write(beta);
      Eigen::Matrix<local_scalar_t__,-1,-1> mu =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, K, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(mu,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(N, K),
        "assigning variable mu");
      out__.write(mu);
      Eigen::Matrix<local_scalar_t__,-1,1> sigmas_mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(sigmas_mu,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable sigmas_mu");
      out__.write_free_lb(0, sigmas_mu);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(D), static_cast<size_t>(K)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "mu", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sigmas_mu",
        "double", std::vector<size_t>{static_cast<size_t>(K)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,-1> beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(D, K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= D; ++sym2__) {
            current_statement__ = 1;
            stan::model::assign(beta, beta_flat__[(pos__ - 1)],
              "assigning variable beta", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 1;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(beta);
      Eigen::Matrix<local_scalar_t__,-1,-1> mu =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 2;
        mu_flat__ = context__.vals_r("mu");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 2;
            stan::model::assign(mu, mu_flat__[(pos__ - 1)],
              "assigning variable mu", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 2;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(mu);
      Eigen::Matrix<local_scalar_t__,-1,1> sigmas_mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> sigmas_mu_flat__;
        current_statement__ = 3;
        sigmas_mu_flat__ = context__.vals_r("sigmas_mu");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(sigmas_mu, sigmas_mu_flat__[(pos__ - 1)],
            "assigning variable sigmas_mu", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, sigmas_mu);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"beta", "mu", "sigmas_mu"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(D),
                                                 static_cast<size_t>(K)},
                std::vector<size_t>{static_cast<size_t>(N),
                  static_cast<size_t>(K)},
                std::vector<size_t>{static_cast<size_t>(K)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= D; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigmas_mu" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= D; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigmas_mu" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(D) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"sigmas_mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(D) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"sigmas_mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((D * K) + (N * K)) + K);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((D * K) + (N * K)) + K);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_lnm_namespace::model_lnm;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_lnm_namespace::profiles__;
}
#endif
#endif
