% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortmat.R
\name{sortmat}
\alias{sortmat}
\title{Reorders to rows (corresponding to different clusters) of a matrix of medians to a desired order}
\usage{
sortmat(mat, desiredorder)
}
\arguments{
\item{mat}{matrix of median data}

\item{desiredorder}{row labels from matrix in desired order}
}
\value{
Returns a matrix with rows rearranged in desired order
}
\description{
Reorders to rows (corresponding to different clusters) of a matrix of medians to a desired order
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
medians<-clustermeds(citrus.foldFeatureSet=citrus.foldFeatureSet,
                     citrus.foldClustering=citrus.foldClustering,
                     medsofinterest=c("Red","Blue"),
                     citrus.combinedFCSSet=citrus.combinedFCSSet)
names<-rownames(medians)
names<-names[c(31,1:30)]
sortedmedians<-sortmat(mat=medians,desiredorder=names)
}
