% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miebl_cp.R
\name{miebl_cp}
\alias{miebl_cp}
\title{Compares posterior distributions from different reports}
\usage{
miebl_cp(R1, R2, R3 = NULL, R4 = NULL, R5 = NULL)
}
\arguments{
\item{R1}{object produced by miebl_re; start from highest performance criterion to lowest}

\item{R2}{object produced by miebl_re}

\item{R3}{object produced by miebl_re}

\item{R4}{object produced by miebl_re}

\item{R5}{object produced by miebl_re}
}
\value{
a combined plot of the posterior distributions for each performance criterion
}
\description{
Compares posterior distributions from different reports
}
\examples{
#create a miebl output for default 90\% desired true mastery
xx<-miebl(10)
#Uses the miebl output for miebl_re for 90\% and 80\% performance criterion
r1<-miebl_re(xx,mc=90)
r2<-miebl_re(xx,mc=80)
miebl_cp(r1,r2)
}
