% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{class}
\name{mgwrsar-class}
\alias{mgwrsar-class}
\title{Class of mgwrsar Model.}
\description{
Class of mgwrsar Model.
}
\section{Slots}{

\describe{
\item{\code{Betav}}{matrix, the estimated varying coefficients, dim(n,kv).}

\item{\code{Betac}}{numeric, the estimated constant coefficients, length kc.}

\item{\code{Model}}{character, The type of model.}

\item{\code{fixed_vars}}{character, a vector with name of constant covarariate.}

\item{\code{Y}}{numeric, the dependent variable.}

\item{\code{XC}}{matrix, the explanatory variables with constant coefficients.}

\item{\code{XV}}{matrix, the explanatory variables with varying coefficients.}

\item{\code{X}}{matrix, the explanatory variables.}

\item{\code{W}}{SparseMatrix, the spatial weight matrix for spatial dependence.}

\item{\code{isgcv}}{logical, if gcv has been computed.}

\item{\code{edf}}{numeric, the estimated degrees of freedom.}

\item{\code{formula}}{\code{formula}}

\item{\code{data}}{dataframe, The dataframe used for computation.}

\item{\code{Method}}{character, the estimation technique for computing the models with Spatial Dependence. '2SLS' or 'B2SLS', default '2SLS'.}

\item{\code{coords}}{matrix, the spatial coordinates of observations.}

\item{\code{H}}{numeric, the bandwidth vector.}

\item{\code{H2}}{numeric, the time bandwidth vector.}

\item{\code{kernels}}{character, the type of kernel.}

\item{\code{adaptive}}{logical, adaptive kernel.}

\item{\code{Type}}{character, the type of General Kernel Product.}

\item{\code{TP}}{numeric, index of target points.}

\item{\code{SSRtp}}{numeric, the sum of square residuals for TP.}

\item{\code{SSR}}{numeric, the sum of square residuals.}

\item{\code{residuals}}{numeric, the vector of residuals.}

\item{\code{fit}}{numeric, the vector of fitted values.}

\item{\code{pred}}{numeric, the vector of predicted values.}

\item{\code{sev}}{matrix, local standard error of varying coefficients.}

\item{\code{se}}{numeric, standard error of constant coefficients.}

\item{\code{tS}}{numeric, Trace(S).}

\item{\code{Shat,}}{hat matrix}

\item{\code{R_k,}}{list of hat matrix by var}

\item{\code{h_w}}{numeric, the bandwidth value for computing W, default 0.}

\item{\code{kernel_w}}{the type of kernel for computing W, default NULL.}

\item{\code{RMSE}}{numeric, Root Mean Square Error for Target Points.}

\item{\code{RMSEtp}}{numeric, Root Mean Square Error for all Points.}

\item{\code{CV}}{numeric, Leave One Out CV.}

\item{\code{AIC}}{numeric,  Akaike Criteria.}

\item{\code{AICc}}{numeric, Corrected Akaike Criteria.}

\item{\code{AICctp}}{numeric, Corrected Akaike Criteria for TP}

\item{\code{BIC}}{numeric, Bayesian Information Criteria.}

\item{\code{R2}}{numeric, R2.}

\item{\code{R2_adj}}{numeric, adjusted R2.}

\item{\code{get_ts}}{logical, if trace of hat matrix Tr(S) should be stored.}

\item{\code{NN}}{numeric, the maximum number of neighbors for weights computation}

\item{\code{doMC}}{logical, parallel computation.}

\item{\code{ncore}}{numeric, number of cores.}

\item{\code{mycall}}{a call, the call of the model.}

\item{\code{ctime}}{numeric, the computing times in seconds.}

\item{\code{HRMSE}}{matrix, RMSE log.}

\item{\code{HBETA}}{list, estimated BETA at each iteration.}

\item{\code{loglik}}{numeric, value of loglik.}

\item{\code{G}}{list, list of neighboring index and distances (knn object from nabor package).}

\item{\code{V}}{numeric, neighbors sequence for TDS.}

\item{\code{Vt}}{numeric, neighbors sequence for TDS.}

\item{\code{Z}}{numeric, time for GDT kernel type}

\item{\code{TS}}{numeric, Diagonal of Hat Matrix}

\item{\code{alpha}}{numeric, ratio for GDT kernels}

\item{\code{theta}}{numeric, ratio for GDT kernels}
}}

