% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgwrhw.R
\name{mgwrhw}
\alias{mgwrhw}
\title{mgwrhw}
\usage{
mgwrhw(dpk, pers.reg, coor_lat, coor_long, vardep, GWRonly, kp, alp)
}
\arguments{
\item{dpk}{dataframe all variables that come from the shp data format and have geometric attributes that are usually imported with the st_read function from library(sf)}

\item{pers.reg}{The form of the regression equation that will be used as a GWR model is in the general form y~x1+x2+x3}

\item{coor_lat}{the name of the variable that is in the dpk dataframe that contains latitude coordinates and is written with quotation marks such as "Latitude" which indicates a column named Latitude}

\item{coor_long}{the name of the variable that is in the dpk dataframe that contains latitude coordinates and is written with quotation marks such as "Longitude" which indicates a column named Longitude}

\item{vardep}{the name of a variable that is in a dpk dataframe that contains one dependent variable and is written with quotation marks such as "y" which indicates a column named y}

\item{GWRonly}{user option to choose to display GWR results only or to form an MGWR model. Option 1 displays GWR output only while option 0 displays GWR and MGWR output.}

\item{kp}{user option to select kernel functions. Option 1 for Fixed Bisquare, option 2 for Fixed Gaussian, option 3 for Adaptive Bisquare, and option 4 for Adaptive Bisquare}

\item{alp}{alpha value (type 1 error) used in spatial regression model}
}
\value{
no return value, called for side effects

This function returns a list with the following objects:
\subsection{for Mixed GWR model (GWRonly = 0)}{

the general equation form of the Mixed GWR model is

\eqn{y_{i}} = \eqn{\beta_{0}}(\eqn{u_{i}},\eqn{v_{i}}) + \eqn{\sum}\eqn{\beta_{k}}(\eqn{u_{i}},\eqn{v_{i}})\eqn{x_{ik}} + \eqn{\sum}\eqn{\beta_{k}}\eqn{x_{ik}} + \eqn{\epsilon_{i}}

\describe{
\item{output}{A character vector containing the captured output of GWR model and Mixed GWR model.}
\item{gwr}{The result of the GWR model include CV, bandwith, Quasi R square, etc.}
\item{Variability.Test}{Results of the variability test for global and local variables.}

\eqn{H_{0}} : \eqn{\beta_{k}}(\eqn{u_{1}},\eqn{v_{1}}) = \eqn{\beta_{k}}(\eqn{u_{2}},\eqn{v_{2}}) = ... = \eqn{\beta_{k}}(\eqn{u_{n}},\eqn{v_{n}})

\eqn{H_{1}} : not all \eqn{\beta_{k}}(\eqn{u_{i}},\eqn{v_{i}}) (\eqn{i} = 1, 2, ..., n) are equal

\deqn{F_{Variability.Test_{k}} = \frac{V^{2}_{k}{/}\gamma_{1}}{\widehat{\sigma}}}

Conclusion : Reject \eqn{H_{0}} if \eqn{F_{Variability.Test_{k}}} \eqn{\geq} \eqn{F_{\alpha}}(\eqn{\frac{\gamma_{1}^{2}}{\gamma_{2}},\frac{\delta_{1}^{2}}{\delta_{2}}}) or p-value < \eqn{\alpha}.

If \eqn{H_{0}} is rejected, it means that the k-th variable has a local influence, while if \eqn{H_{0}} fails to be rejected, it means that the k-th variable has a global influence.

Reference : Leung, Y., Mei, C.L., & Zhang, W.X., (2000). "Statistic Tests for Spatial Non-Stationarity Based on the Geographically Weighted Regression Model", Environment and Planning A, 32 pp. 9-32. \url{doi:10.1068/a3162}.

\item{F1.F2.F3.mgwr.Test}{Results of the F1(GoF Mixed GWR), F2(Global Simultaneous), F3(Local Simultaneous) tests.}

F1(GoF Mixed GWR) :

\eqn{H_{0}} : \eqn{\beta_{k}}(\eqn{u_{i}},\eqn{v_{i}}) = \eqn{\beta_{k}}

\eqn{H_{1}} : at least there is one  \eqn{\beta_{k}}(\eqn{u_{i}},\eqn{v_{i}}) \eqn{\neq} \eqn{\beta_{k}}

\deqn{F(1) = \frac{y^{T}((I-H)-(I-S)^{T}(I-S))y {/} v_{1}} {y^{T}(I-S)^{T}(I-S)y {/} u_{1}}}

if \eqn{H_{0}} is rejected, it shows that the Mixed GWR model is different from the OLS model]

F2(Global Simultaneous) :

\eqn{H_{0}} : \eqn{\beta_{q+1}} = \eqn{\beta_{q+2}} = ... = \eqn{\beta_{p}} = 0

\eqn{H_{1}} : at least one of \eqn{\beta_{k}} \eqn{\neq} 0

\deqn{F(2) = \frac{y^{T}((I-S_{l})^{T}(I-S_{l})-(I-S)^{T}(I-S))y {/} r_{1}} {y^{T}(I-S)^{T}(I-S)y {/} u_{1}}}

If \eqn{H_{0}} is rejected, it indicates that there is at least one global variable that has a significant effect in the model

F3(Local Simultaneous)

\eqn{H_{0}} : \eqn{\beta_{1}}(\eqn{u_{i}},\eqn{v_{i}}) = \eqn{\beta_{2}}(\eqn{u_{i}},\eqn{v_{i}}) = ... = \eqn{\beta_{q}}(\eqn{u_{i}},\eqn{v_{i}}) = 0

\eqn{H_{1}} : at least one of \eqn{\beta_{k}}(\eqn{u_{i}},\eqn{v_{i}}) \eqn{\neq} 0

\deqn{F(2) = \frac{y^{T}((I-S_{g})^{T}(I-S_{g})-(I-S)^{T}(I-S))y {/} r_{1}} {y^{T}(I-S)^{T}(I-S)y {/} u_{1}}}

If \eqn{H_{0}} is rejected, it indicates that there is at least one local variable that has a significant effect in the model

Reference : Yasin, & Purhadi. (2012). "Mixed Geographically Weighted Regression Model (Case Study the Percentage of Poor Households in Mojokerto 2008)". European Journal of Scientific Research, 188-196.
\url{https://www.researchgate.net/profile/Hasbi-Yasin-2/publication/289689583_Mixed_geographically_weighted_regression_model_case_study_The_percentage_of_poor_households_in_Mojokerto_2008/links/58e46aa40f7e9bbe9c94d641/Mixed-geographically-weighted-regression-model-case-study-The-percentage-of-poor-households-in-Mojokerto-2008.pdf}.

\item{Global.Partial.Test}{Results of the global partial test.}

\eqn{H_{0}} : \eqn{\beta_{k}} = 0 (k-th global variables are not significant)

\eqn{H_{1}} : \eqn{\beta_{k}} \eqn{\neq} 0 (k-th global variables are significant)

\deqn{T_{g} = \frac{\widehat{\beta_{k}}}{\widehat{\sigma}\sqrt{g_{kk}}}}

If \eqn{H_{0}} is rejected, it indicates that the k-th global variable has a significant effect

Reference : Yasin, & Purhadi. (2012). "Mixed Geographically Weighted Regression Model (Case Study the Percentage of Poor Households in Mojokerto 2008)". European Journal of Scientific Research, 188-196.
\url{https://www.researchgate.net/profile/Hasbi-Yasin-2/publication/289689583_Mixed_geographically_weighted_regression_model_case_study_The_percentage_of_poor_households_in_Mojokerto_2008/links/58e46aa40f7e9bbe9c94d641/Mixed-geographically-weighted-regression-model-case-study-The-percentage-of-poor-households-in-Mojokerto-2008.pdf}.

\item{map.mgwr}{Visualization of Mixed GWR results in the form of a regional map with variables that are significant globally and locally.}
\item{Global_variable}{A list of global variables used in the analysis.}
\item{Local_variable}{A list of local variables used in the analysis.}
\item{AICc}{The corrected Akaike Information Criterion.}
\item{AIC}{The Akaike Information Criterion.}
\item{R_square}{The coefficient of determination.}
\item{adj_R_square}{The adjusted coefficient of determination.}
\item{table.mgwr}{A data frame about output table of MGWR model (include estimator, standar error, t-statistics, p-value).}
}
}

\subsection{for GWR model (GWRonly = 1)}{

the general equation form of the GWR model is

\eqn{y_{i}} = \eqn{\beta_{0}}(\eqn{u_{i}},\eqn{v_{i}}) + \eqn{\sum}\eqn{\beta_{k}}(\eqn{u_{i}},\eqn{v_{i}})\eqn{x_{ik}} + \eqn{\epsilon_{i}}

\describe{
\item{output}{A character vector containing the captured output of GWR model.}
\item{gwr}{A character vector containing the result of the GWR model include CV, bandwith, Quasi R square, etc.}
\item{GoF.test}{A character vector containing the results of the Godness of Fit Test.}
\item{anova_gwr}{Results of the anova table.}
\item{map.gwr}{Visualization of the GWR results.}
\item{table.gwr}{A data frame about output table of GWR model (include estimator, standar error, t-statistics, p-value).}
}
}
}
\description{
displays the GWR and mixed GWR models automatically along with the tests and significance maps that are formed.
}
\examples{
mod1 = mgwrhw(dpk=redsb, pers.reg = Y ~ X2 + X4 + X5 + X6,
coor_lat = "Latitude", coor_long = "Longitude",
vardep = "Y", GWRonly = 0, kp = 3, alp = 0.05)
mod1$gwr
mod1$Variability.Test
mod1$Global_variable
mod1$Local_variable
mod1$F1.F2.F3.mgwr.Test
mod1$Global.Partial.Test
mod1$map.mgwr
}
