% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_d.R
\name{d}
\alias{d}
\title{Willmott's Index of Agreement (d)}
\usage{
d(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the Willmott's index of agreement (d) for a
continuous predicted-observed dataset.
}
\details{
The d index it is a normalized, dimensionless metric that tests general agreement.
It measures both accuracy and precision using squared residuals. It is bounded between 0 and 1.
The disadvantage is that d is an asymmetric index, that is, dependent to what is orientation of
predicted and observed values.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
d(obs = X, pred = Y)
}
}
\references{
Willmott (1981).
On the validation of models.
\emph{Phys. Geogr. 2, 184–194.} \doi{10.1080/02723646.1981.10642213}
}
