% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptscol.R
\name{p.tscol}
\alias{p.tscol}
\title{Bar plot in time serie format}
\usage{
p.tscol(
  data,
  xaxis,
  yaxis,
  dateformat = "\%Y-\%m",
  datebreaks = "1 month",
  ybreaks = 10,
  percent = FALSE,
  yaccuracy = 0.01,
  ydecimalmark = ".",
  title = "Title",
  xlab = "X axis",
  ylab = "Y axis",
  stitle = NULL,
  note = NULL,
  ctitles = "black",
  cscales = ctitles,
  cbgrid = "white",
  clgrid = cbgrid,
  cplot = "white",
  cserie = "black",
  cbserie = cserie,
  cticks = "black",
  lwdserie = 1,
  pnote = 1,
  cbord = cplot,
  titlesize = 20,
  wordssize = 12,
  snote = 11,
  xlim = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{xaxis}{x axis data}

\item{yaxis}{y axis data}

\item{dateformat}{format of date in x axis (need a dataformat string) (default ="\%Y-\%m")}

\item{datebreaks}{datebreaks in x axis (default="1 month")}

\item{ybreaks}{number of y axis breaks (default=10)}

\item{percent}{If TRUE y axis in percent (default=F)}

\item{yaccuracy}{a round for y axis (default=0.01)}

\item{ydecimalmark}{y decimal mark (default=".")}

\item{title}{title of plot}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{stitle}{subtitle}

\item{note}{note}

\item{ctitles}{color of titles (title,xlab,ylab)}

\item{cscales}{color of the scales (default= same ctitles)}

\item{cbgrid}{color of grid background}

\item{clgrid}{color of grid lines}

\item{cplot}{color of plot background}

\item{cserie}{color of serie}

\item{cbserie}{color of serie border (default= same cserie)}

\item{cticks}{color of axis ticks}

\item{lwdserie}{size of serie}

\item{pnote}{position of note (default=1) (only numbers)}

\item{cbord}{color of plot border (default= same cplot)}

\item{titlesize}{size of title (default=20) (only numbers)}

\item{wordssize}{size of words (default=12) (only numbers)}

\item{snote}{size of note (default=11) (only numbers)}

\item{xlim}{limit of x axis (default=NULL)}
}
\value{
Return a graphic.
}
\description{
p.tscol make a bar plot in time serie format. The data don't need be a ts object.
}
\examples{
v=data.frame("x"=seq.Date(as.Date('2020-01-01'),
to = as.Date('2020-04-01'),by='month'),"y"=c(5,3,7,2))

p.tscol(v,v$x,v$y,title="Simple example")

p.tscol(v,v$x,v$y,dateformat="\%B",title="Example with colorbyvar",
ylab="Values",xlab=NULL,cserie=p.colorbyvar(v$y))

v=data.frame("x"=seq.Date(as.Date('2020-01-01'),
to = as.Date('2020-04-01'),by='month'),"y"=c(0.03,-0.05,0.08,-0.02))

p.tscol(v,v$x,v$y,percent=TRUE,title="Example with percent data",xlab=NULL,ylab=NULL)

p.tscol(v,v$x,v$y,percent=TRUE,yaccuracy=1,title="y accuracy set",xlab=NULL,ylab=NULL)

p.tscol(v,v$x,v$y,percent=TRUE,yaccuracy=1,title="Example with colorbypositive",xlab=NULL,ylab=NULL,
cserie=p.colorbypositive(v$y),cbserie="black",lwdserie=1) #lwdserie change the board in this case

}
