% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num2month.R
\name{num2month}
\alias{num2month}
\title{Transform month numbers to month names}
\usage{
num2month(date, abbreviate = FALSE, ptbr = FALSE)
}
\arguments{
\item{date}{a month numbers vector}

\item{abbreviate}{abbreviate months name}

\item{ptbr}{transalate result to "Portugues (Brasil)".}
}
\value{
Return a month names.
}
\description{
num2month transform month numbers to month names
}
\examples{
v=c(01,02,03,04,05,06,07,08,09,10,11,12)
num2month(v)
num2month(v,abbreviate=TRUE)
num2month(v,abbreviate=FALSE,ptbr=TRUE)
num2month(v,abbreviate=TRUE,ptbr=TRUE)

v=data.frame('date'=c(01,02,03,04),'values'=c(18,27,10,48))
num2month(v$date)
#or
num2month(v[[1]])

#you can substitute column with function:
v$date = num2month(v$date)
v[[1]] = num2month(v[[1]])

#The data can be a string, but is recommended use numbers,
#see a string examples:
v=c('01','02','03','04','05','06','07','08','09','10','11','12')
num2month(v)

v=c('1','2','3','4','5','6','7','8','9','10','11','12')
num2month(v)



}
