% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_fronts.R
\name{calc_fdiag}
\alias{calc_fdiag}
\title{F diagnostic}
\usage{
calc_fdiag(
  t_fld,
  u_fld,
  v_fld,
  w_fld,
  lev_p,
  lat = NULL,
  dx = 0.25,
  dy = 0.25,
  mode = "lonlat"
)
}
\arguments{
\item{t_fld}{temperature field [K]}

\item{u_fld}{zonal velocity field [m/s]}

\item{v_fld}{meridional velocity field [m/s]}

\item{w_fld}{vertical velocity field [m/s]}

\item{lev_p}{vector containing pressure levels [Pa]}

\item{lat}{only for lonlat mode: vector containing latitude}

\item{dx}{x resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{dy}{y resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{mode}{the horizontal coordinate system, options are lonlat for a longitude-latitude-grid (default), or cartesian for an equidistant cartesian grid}
}
\value{
F diagnostic (dimensionless)
}
\description{
Calculates the F diagnostic
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
fdiag=calc_fdiag(data$temp,data$u,data$v,data$w,data$lev,data$lat)
}
