% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{use_copy_default}
\alias{use_copy_default}
\title{Get data copy option}
\usage{
use_copy_default()
}
\value{
Logical value indicating whether to use data copies (TRUE) or
modify data in place (FALSE). Default is TRUE.
}
\description{
Retrieves the current setting for the use_copy option,
which controls whether survey operations create copies of
the data or modify in place.
}
\details{
The use_copy option affects memory usage and performance:
\itemize{
\item TRUE: Creates copies, safer but uses more memory
\item FALSE: Modifies in place, more efficient but requires caution
}
}
\examples{
# Check current setting
current_setting <- use_copy_default()
print(current_setting)

}
\seealso{
\code{\link{set_use_copy}} to change the setting

Other options: 
\code{\link{get_engine}()},
\code{\link{lazy_default}()},
\code{\link{set_engine}()},
\code{\link{set_lazy_processing}()},
\code{\link{set_use_copy}()},
\code{\link{show_engines}()}
}
\concept{options}
