% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_splines.R
\name{pool_splines}
\alias{pool_splines}
\title{Title Pool meta-analysis estimates and estimates from a regression model.}
\usage{
pool_splines(
  v,
  meta.df,
  glm.res,
  cor.m = NULL,
  x.range = NULL,
  full.output = FALSE
)
}
\arguments{
\item{v}{Name of the covariate, which is modeled using an \code{nsk} spline (see package \code{splines2}).}

\item{meta.df}{Meta-analysis estimates: dataframe with columns \code{est} (e.g. log HR estimate), \code{est.var} (estimated variance), \code{variable} (name of the covariate used in the spline) and \code{cov.value} (covariate value at which est and est.var were reported).}

\item{glm.res}{Regression analysis result object.}

\item{cor.m}{Assumed correlation matrix. If NULL (default) or NA then use correlation matrix from \code{glm.res}.}

\item{x.range}{If NULL (default), then take the range from \code{meta.df}, otherwise give range as a vector with two components.}

\item{full.output}{If TRUE then output also the log HR values and 95\% confidence intervals over a grid of covariate values.}
}
\value{
List containing pooled estimates of the spline parameters.
}
\description{
Title Pool meta-analysis estimates and estimates from a regression model.
}
