% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCA.Algorithm.R
\name{SCA}
\alias{SCA}
\title{Optimization using Sine Cosine Algorithm}
\usage{
SCA(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Sine Cosine
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Mirjalili, 2016). The SCA creates multiple initial
random candidate solutions and requires them to fluctuate outwards or towards the
best solution using a mathematical model based on sine and cosine functions. Several
random and adaptive variables also are integrated to this algorithm to emphasize
exploration and exploitation of the search space in different milestones of optimization.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item Initialization: Initialize the first population of candidate solution randomly,
      calculate the fitness of candidate solution and find the best candidate.
\item Update Candidate Position: Update the position with the equation that represent the
      behaviour of sine and cosine function.
\item Update the best candidate if there are candidate solution with better fitness.
\item Check termination criteria, if termination criterion is satisfied, return the
      best candidate as the optimal solution for given problem. Otherwise, back to Update Candidate Position steps.
}
}
\examples{
##################################
## Optimizing the step function

# define step function as objective function
step <- function(x){
    result <- sum(abs((x+0.5))^2)
    return(result)
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-100,100), nrow=2)

## calculate the optimum solution using Sine Cosine Algorithm
resultSCA <- SCA(step, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using step function
optimum.value <- step(resultSCA)

}
\references{
Seyedali Mirjalili, SCA: A Sine Cosine Algorithm for solving optimization problems,
Knowledge-Based Systems, Volume 96, 2016, Pages 120-133, ISSN 0950-7051,
https://doi.org/10.1016/j.knosys.2015.12.022
}
\seealso{
\code{\link{metaOpt}}
}
