% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBS.Algorithm.R
\name{GBS}
\alias{GBS}
\title{Optimization using Gravitational Based Search Algorithm.}
\usage{
GBS(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar, gravitationalConst = max(rangeVar),
  kbest = 0.1)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{gravitationalConst}{a numeric to determine gravitational constant while
calculating total force. The default value is \code{max(rangeVar)}.}

\item{kbest}{a positive numeric between 0 and 1 to determine fraction of population
with best fitness which will affect every candidate solution in population.
The default value is 0.1.}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Gravitational Based Search
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Rashedi, 2009).
GBS use newton law of universal gravitation and second law of motion
to optimize. Every candidate solution in population consider having mass and it move
using newton law of universal gravitation and second law of motion.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item calculate gravitational mass of every candidate solution in population.
\item calculate total force of every candidate solution in population using
      newton law of universal gravitation.
\item calculate acceleration of every candidate solution in population using
      newton second law of motion.
\item update velocity of every candidate solution in population based on its acceleration.
\item move every candidate solution in population based on its velocity.
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop, else back to calculate gravitational mass.
}
}
\examples{
##################################
## Optimizing the schewefel's problem 2.22 function

# define schewefel's problem 2.22 function as objective function
schewefels2.22 <- function(x){
   return(sum(abs(x)+prod(abs(x))))
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using Gravitational Based Search
resultGBS <- GBS(schewefels2.22, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using schewefel's problem 2.22 function
optimum.value <- schewefels2.22(resultGBS)

}
\references{
Rashedi, E., Nezamabadi-Pour, H., & Saryazdi, S. (2009).
GSA: a gravitational search algorithm. Information sciences, 179(13), 2232-2248.
}
\seealso{
\code{\link{metaOpt}}
}
