% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rm5.R
\name{print.rm5}
\alias{print.rm5}
\title{Cochrane review: summary of meta-analyses}
\usage{
\method{print}{rm5}(x, comp.no, outcome.no, ...)
}
\arguments{
\item{x}{An object of class \code{rm5}.}

\item{comp.no}{Comparison number.}

\item{outcome.no}{Outcome number.}

\item{...}{Additional arguments (passed on to \code{metacr}).}
}
\description{
Calculate and print a summary of all meta-analyses in a
Cochrane review.
}
\details{
This function can be used to redo all or selected meta-analyses of
a Cochrane Review of interventions (Higgins et al., 2023).

Review Manager 5 (RevMan 5) was the software used for preparing and
maintaining Cochrane Reviews. In RevMan 5, subgroup analyses can be defined
and data from a Cochrane review can be imported to R using the function
\code{read.rm5}.

The R function \code{\link{metacr}} is called internally.
}
\examples{
# Locate export data file "Fleiss1993_CR.csv"
# in sub-directory of package "meta"
#
filename <- system.file("extdata", "Fleiss1993_CR.csv", package = "meta")
Fleiss1993_CR <- read.rm5(filename)

# Print results for all meta-analysis
#
Fleiss1993_CR

# Print results only for second outcome of first comparison
#
print(Fleiss1993_CR, comp.no = 1, outcome.no = 2)

}
\references{
Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch
VA (editors) (2023):
\emph{Cochrane Handbook for Systematic Reviews of Interventions
  Version 6.4 (updated August 2023)}.
Available from \url{https://www.cochrane.org/authors/handbooks-and-manuals/handbook}
}
\seealso{
\code{\link{summary.meta}}, \code{\link{metacr}},
  \code{\link{read.rm5}}, \code{\link{metabias.rm5}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
