% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.metainf.R
\name{print.metainf}
\alias{print.metainf}
\title{Print results of a leave-one-out meta-analysis}
\usage{
\method{print}{metainf}(
  x,
  prediction = x$prediction,
  overall = x$overall,
  backtransf = x$backtransf,
  header = TRUE,
  lab.NA = ".",
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = gs("digits.pval"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  digits.I2 = gs("digits.I2"),
  digits.cid = gs("digits.cid"),
  digits.percent = 1,
  big.mark = gs("big.mark"),
  scientific.pval = gs("scientific.pval"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  print.stat = FALSE,
  print.tau2 = TRUE,
  print.tau2.ci = FALSE,
  print.tau = TRUE,
  print.tau.ci = FALSE,
  print.I2 = TRUE,
  print.I2.ci = FALSE,
  print.prob = TRUE,
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  text.I2 = gs("text.I2"),
  details.methods = gs("details"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{metainf}}.}

\item{prediction}{A logical indicating whether prediction
intervals should be printed.}

\item{overall}{A logical indicating whether overall results should be
printed.}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. If \code{backtransf=TRUE}, results
for \code{sm="OR"} are printed as odds ratios rather than log
odds ratios, for example.}

\item{header}{A logical indicating whether information on title of
meta-analysis, comparison and outcome should be printed at the
beginning of the printout.}

\item{lab.NA}{A character string to label missing values.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-value of test for overall effect, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance \eqn{\tau^2}, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for
\eqn{\tau}, the square root of the between-study variance
\eqn{\tau^2}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
and Rb statistic, see \code{print.default}.}

\item{digits.cid}{Minimal number of significant digits for
CID / decision thresholds, see \code{print.default}.}

\item{digits.percent}{Minimal number of significant digits for
probabilities, printed as percentages, see \code{print.default}.}

\item{big.mark}{A character used as thousands separator.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
overall effect should be printed according to JAMA reporting
standards.}

\item{print.stat}{A logical value indicating whether z- or t-value
for test of treatment effect should be printed.}

\item{print.tau2}{A logical specifying whether between-study
variance \eqn{\tau^2} should be printed.}

\item{print.tau2.ci}{A logical value indicating whether to print
the confidence interval of \eqn{\tau^2}.}

\item{print.tau}{A logical specifying whether \eqn{\tau}, the
square root of the between-study variance \eqn{\tau^2}, should be
printed.}

\item{print.tau.ci}{A logical value indicating whether to print the
confidence interval of \eqn{\tau}.}

\item{print.I2}{A logical specifying whether heterogeneity
statistic I\eqn{^2} should be printed.}

\item{print.I2.ci}{A logical specifying whether confidence interval for
heterogeneity statistic I\eqn{^2} should be printed.}

\item{print.prob}{A logical specifying whether to print probabilities
of clinically important benefit or harm.}

\item{text.tau2}{Text printed to identify between-study variance
\eqn{\tau^2}.}

\item{text.tau}{Text printed to identify \eqn{\tau}, the square
root of the between-study variance \eqn{\tau^2}.}

\item{text.I2}{Text printed to identify heterogeneity statistic
I\eqn{^2}.}

\item{details.methods}{A logical specifying whether details on
statistical methods should be printed.}

\item{\dots}{Additional arguments (ignored).}
}
\description{
Print results of a leave-one-out meta-analysis
}
\examples{
data(Fleiss1993bin)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac,
  data = Fleiss1993bin, studlab = study, sm = "RR", method = "I")
m1
metainf(m1)
metainf(m1, pooled = "random")
metainf(m1, pooled = "random", prediction = TRUE)

}
\seealso{
\code{\link{metainf}}, \code{\link{settings.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
