% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SE.R
\name{SE_from_SD}
\alias{SE_from_SD}
\title{Standard Error for a Single Group}
\usage{
SE_from_SD(SD, n)
}
\arguments{
\item{SD}{standard deviation}

\item{n}{sample size}
}
\value{
Single group standard error
}
\description{
\strong{IMPORTANT}: For cases involving two groups (e.g., intervention effects), use \code{\link[=SEp_from_SDp]{SEp_from_SDp()}} instead.#'
Calculates the standard error for a single group. This method is only valid for single groups
}
\examples{
# Standard deviation = 2, group size = 50
SE_from_SD(2, 50)
}
\references{
\href{https://handbook-5-1.cochrane.org/chapter_7/7_7_3_2_obtaining_standard_deviations_from_standard_errors_and.htm}{Cochrane Handbook}
}
\seealso{
\code{\link[=SEp_from_SDp]{SEp_from_SDp()}} for two groups
}
