% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-aic-bic.R
\name{aic}
\alias{aic}
\alias{bic}
\title{Maximum likelihood based information criteria}
\usage{
aic(x, ..., force = FALSE)

bic(x, ..., force = FALSE)
}
\arguments{
\item{x}{A \link[=dcm_estimate]{measrdcm} object estimated with
\code{backend = "optim"}.}

\item{...}{Unused.}

\item{force}{If the criterion has already been added to the
model object with \code{\link[=add_criterion]{add_criterion()}}, should it be recalculated. Default is
\code{FALSE}.}
}
\value{
The numeric value of the information criterion.
}
\description{
Calculate information criteria for diagnostic models not estimated with full
Markov chain Monte Carlo (i.e., with \code{method = "optim"}). Available
information include the Akaike information criterion (AIC; Akaike, 1973) and
the Bayesian information criterion (BIC; Schwarz, 1978).
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
model_spec <- dcm_specify(
  qmatrix = dcmdata::mdm_qmatrix,
  identifier = "item"
)
model <- dcm_estimate(
  dcm_spec = model_spec,
  data = dcmdata::mdm_data,
  identifier = "respondent",
  method = "optim",
  seed = 63277
)

aic(model)

bic(model)
\dontshow{\}) # examplesIf}
}
\references{
Akaike, H. (1973). Information theory and an extension of the
maximum likelihood principle. In B. N. Petrov & F. Csáki (Eds.),
\emph{Proceedings of the Second International Symposium on Information Theory}
(pp. 267-281). Akademiai Kiado.

Schwarz, G. (1978). Estimating the dimension of a model.
\emph{The Annals of Statistics, 6}(2), 461–464. \doi{10.1214/aos/1176344136}
}
