% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contact_matrix.R
\name{contact_matrix}
\alias{contact_matrix}
\alias{get_contact_matrix}
\alias{set_contact_matrix}
\alias{get_contact_matrix.default}
\alias{get_contact_matrix.epiworld_measlesmixing}
\alias{get_contact_matrix.epiworld_measlesmixingriskquarantine}
\alias{set_contact_matrix.default}
\alias{set_contact_matrix.epiworld_measlesmixing}
\alias{set_contact_matrix.epiworld_measlesmixingriskquarantine}
\title{Get and Set Contact Matrix}
\usage{
get_contact_matrix(model)

\method{get_contact_matrix}{default}(model)

\method{get_contact_matrix}{epiworld_measlesmixing}(model)

\method{get_contact_matrix}{epiworld_measlesmixingriskquarantine}(model)

set_contact_matrix(model, value)

\method{set_contact_matrix}{default}(model, value)

\method{set_contact_matrix}{epiworld_measlesmixing}(model, value)

\method{set_contact_matrix}{epiworld_measlesmixingriskquarantine}(model, value)
}
\arguments{
\item{model}{An epiworld model object of class \code{epiworld_measlesmixing} or
\code{epiworld_measlesmixingriskquarantine}.}

\item{value}{A row-stochastic matrix representing contact rates between
population groups. The matrix should be square with dimensions matching
the number of entities (population groups) in the model, and each row
should sum to 1.}
}
\value{
\itemize{
\item \code{get_contact_matrix()} returns a numeric matrix representing the contact
rates between population groups.
\item \code{set_contact_matrix()} returns the model object invisibly (called for
its side effects).
}
}
\description{
These functions allow getting and setting the contact matrix for
measles mixing models. The contact matrix specifies the mixing patterns
between different population groups.
}
\details{
The contact matrix is a row-stochastic matrix where entry \verb{[i, j]}
represents the probability that an individual in group \code{i} will make
contact with someone in group \code{j}, given that they make a contact.
Each row must sum to 1.

These functions are currently only available for:
\itemize{
\item \link{ModelMeaslesMixing}
\item \link{ModelMeaslesMixingRiskQuarantine}
}

Other mixing models in epiworld will have these methods available in the
near future.
}
\examples{
# Create entities for three population groups
e1 <- entity("Population 1", 1000, as_proportion = FALSE)
e2 <- entity("Population 2", 1000, as_proportion = FALSE)
e3 <- entity("Population 3", 1000, as_proportion = FALSE)

# Create an identity contact matrix (no mixing between groups)
cmatrix <- diag(3)

N <- 3000

# Create a measles mixing model
model <- ModelMeaslesMixing(
  n                        = N,
  prevalence               = 1 / N,
  contact_rate             = 15,
  transmission_rate        = 0.9,
  vax_efficacy             = 0.97,
  vax_reduction_recovery_rate = 0.8,
  incubation_period        = 10,
  prodromal_period         = 3,
  rash_period              = 7,
  contact_matrix           = cmatrix,
  hospitalization_rate     = 0.1,
  hospitalization_period   = 10,
  days_undetected          = 2,
  quarantine_period        = 14,
  quarantine_willingness   = 0.9,
  isolation_willingness    = 0.8,
  isolation_period         = 10,
  prop_vaccinated          = 0.95,
  contact_tracing_success_rate = 0.8,
  contact_tracing_days_prior = 4
)

# Add entities to the model
model |>
  add_entity(e1) |>
  add_entity(e2) |>
  add_entity(e3)

# Get the contact matrix (note: requires running the model first)
set.seed(123)
run(model, ndays = 10)
original_matrix <- get_contact_matrix(model)
print(original_matrix)

# Create a new random row-stochastic matrix
new_matrix <- matrix(
  c(0.8, 0.1, 0.1,
    0.1, 0.7, 0.2,
    0.15, 0.15, 0.7),
  nrow = 3, byrow = TRUE
)

# Set the new contact matrix
set_contact_matrix(model, new_matrix)

# Verify the change
updated_matrix <- get_contact_matrix(model)
print(updated_matrix)

}
