% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcse_multi.R
\name{mcse.multi}
\alias{mcse.multi}
\title{Multivariate Monte Carlo standard errors for expectations}
\usage{
mcse.multi(x, method = "bm", r = 3, size = NULL, g = NULL,  
                  adjust = TRUE, blather = FALSE)
}
\arguments{
\item{x}{A matrix or data frame of Markov chain output. Number of rows is the Monte
Carlo sample size.}

\item{method}{Any of \dQuote{\code{bm}},\dQuote{\code{obm}},\dQuote{\code{bartlett}},\dQuote{\code{tukey}}. \dQuote{\code{bm}}
represents batch means estimator, \dQuote{\code{obm}} represents the overlapping batch means estimator,
  and \dQuote{\code{bartlett}} and \dQuote{\code{tukey}} represent the modified-Bartlett window and
  the Tukey-Hanning windows for the spectral variance estimators.}

\item{r}{The lugsail parameters (\code{r}) that converts a lag window into its lugsail
equivalent. Larger values of \code{r} will typically imply less underestimation of \dQuote{\code{cov}},
but higher variability of the estimator. Default is \code{r = 3} and \code{r = 1,2} are
good choices. \code{r > 5} is not recommended.}

\item{size}{Represents the batch size in \dQuote{\code{bm}} and the truncation point in \dQuote{\code{bartlett}} and
\dQuote{\code{tukey}}. Default is \code{NULL} which implies that an optimal batch size is calculated
using the \code{batchSize} function. Can take character values of \dQuote{\code{sqroot}} and
\dQuote{\code{cuberoot}} or any numeric value between 1 and n/2. \dQuote{\code{sqroot}} means
size is floor(n^(1/2)) and \dQuote{\code{cuberoot}} means size is floor(n^(1/3)).}

\item{g}{A function that represents features of interest. \code{g} is applied to each row of \code{x} and
thus \code{g} should take a vector input only. If \code{g} is \code{NULL}, \code{g} is set to be identity, which
is estimation of the mean of the target density.}

\item{adjust}{Defaults to \code{TRUE}. logical for whether the matrix should automatically be adjusted if unstable.}

\item{blather}{If \code{TRUE}, returns under-the-hood workings of the package.}
}
\value{
A list is returned with the following components,
 \item{cov}{a covariance matrix estimate.}
 \item{est}{estimate of g(x).}
 \item{nsim}{number of rows of the input x.}
 \item{eigen_values}{eigen values of the estimate cov.}
 \item{method}{method used to calculate matrix cov.}
 \item{size}{value of size used to calculate cov.}
 \item{Adjustment_Used}{whether an adjustment was used to calculate cov.}
}
\description{
Function returns the estimate of the covariance matrix in the Markov Chain CLT using batch means
or spectral variance methods (with different lag windows). The function also returns the Monte
Carlo estimate.
}
\examples{
## Bivariate Normal with mean (mu1, mu2) and covariance sigma
n <- 1e3
mu <- c(2, 50)
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
out <- BVN_Gibbs(n, mu, sigma)

mcse.bm <- mcse.multi(x = out)
mcse.tuk <- mcse.multi(x = out, method = "tukey")

# If we are only estimating the mean of the first component,
# and the second moment of the second component

g <- function(x) return(c(x[1], x[2]^2))
mcse <- mcse.multi(x = out, g = g)
}
\references{
Vats, D., Flegal, J. M., and, Jones, G. L Multivariate output analysis for Markov chain Monte Carlo, 
\emph{Biometrika}, \bold{106}, 321-337.

Vats, D., Flegal, J. M., and, Jones, G. L. (2018) Strong Consistency of multivariate spectral variance 
estimators for Markov chain Monte Carlo, \emph{Bernoulli}, \bold{24}, 1860-1909.
}
\seealso{
\code{\link{batchSize}}, which computes an optimal batch size. 
\code{\link{mcse.initseq}}, which computes an initial sequence estimator.
\code{\link{mcse}}, which acts on a vector. 
\code{\link{mcse.mat}}, which applies mcse to each column of a matrix or data frame. 
\code{\link{mcse.q}} and \code{\link{mcse.q.mat}}, which compute standard
errors for quantiles.
}
