% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{type_freqs}
\alias{type_freqs}
\alias{type_freq}
\title{Retrieve frequencies from 'freqlist' object}
\usage{
type_freqs(x, types = NULL, with_names = FALSE, ...)

type_freq(x, types = NULL, with_names = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{\link{freqlist}}.}

\item{types}{\code{NULL} or a character vector or an object of the class
\code{\link{types}}.

If the argument \code{types} is \code{NULL}, then the frequencies of all
the items in \code{x} are returned, in the order in which
these items appear in \code{x}.

If the argument \code{types} is a character vector or an object of the
class \code{\link{types}}, then only the frequencies (in \code{x})
of the items in \code{types} are given,
in the order in which these items appear in \code{types}.
For all items in \code{types} that do not occur in \code{x},
a frequency of zero is returned.}

\item{with_names}{Logical. Whether or not the items in the output should
be given names. If \code{with_names} is \code{TRUE}, then the names
of the types in the frequency list are used as names.}

\item{...}{Additional arguments.}
}
\value{
Numeric vector representing the frequencies of the items.
}
\description{
\code{type_freq} and \code{type_freqs} retrieve the frequency of all or
some of the items of a \code{\link{freqlist}} object.
}
\examples{
(flist <- freqlist("The man and the mouse.", as_text = TRUE))

type_freqs(flist) # frequencies of all items
type_names(flist) # names of all items

type_freqs(flist, with_names = TRUE) # frequencies of all types, with names
type_freqs(flist, c("man", "the")) # frequencies of specific items ...
type_freqs(flist, c("the", "man")) # ... in the requested order
type_freq(flist, "the")            # frequency of one item

# frequencies of specific items can also be printed using subsetting
flist[c("the", "man")] 
flist["the"]
}
\seealso{
type_names
}
