% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{drop_empty_rc}
\alias{drop_empty_rc}
\title{Drop empty rows and columns from a matrix}
\usage{
drop_empty_rc(x)
}
\arguments{
\item{x}{A matrix, assumed to contain frequency counts.}
}
\value{
Matrix, with all-zero rows and columns removed.
}
\description{
With \code{x} a matrix containing frequency counts, \code{drop_empty_rc} makes
a copy of \code{x} from which the all-zero rows and all-zero columns are removed.
No checks are performed by this function.
}
\details{
This is just a convenience function. It is identical to, and implemented as,
\code{x[rowSums(x) > 0, colSums(x) > 0, drop = FALSE]}.
}
\examples{
# first example
m <- matrix(nrow = 3, byrow = TRUE,
            dimnames = list(c('r1','r2','r3'),
                           c('c1','c2','c3')),
           c(10, 0, 4,
             0, 0, 0,
             5, 0, 7))

m
m2 <- drop_empty_rc(m)
m2

## second example
m <- matrix(nrow = 3, byrow = TRUE,
           dimnames = list(c('r1','r2','r3'),
                          c('c1','c2','c3')),
           c(0, 0, 4,
             0, 0, 0,
             0, 0, 7))
m
m2 <- drop_empty_rc(m)
m2

## third example
m <- matrix(nrow = 3, byrow = TRUE,
            dimnames = list(c('r1','r2','r3'),
                            c('c1','c2','c3')),
           c(0, 0, 0,
             0, 0, 0,
             0, 0, 0))
m
m2 <- drop_empty_rc(m)
m2 
}
