% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{as_numeric}
\alias{as_numeric}
\alias{as_numeric.default}
\title{Coerce object to a numeric vector}
\usage{
as_numeric(x, ...)

\method{as_numeric}{default}(x, ...)
}
\arguments{
\item{x}{An object to coerce.}

\item{...}{Additional arguments.}
}
\value{
A numeric vector.
}
\description{
This generic method turns its first argument \code{x} or at least part of the information
in it into a numeric object. It is an alternative notation for \code{\link[base:numeric]{base::as.numeric()}}.
}
\examples{
(flist <- freqlist(tokenize("The old story of the old man and the sea.")))

# extract frequency counts from a frequency list
as_numeric(flist)
as.numeric(flist)

# preferable alternative
type_freqs(flist)
}
