% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_utilities.R
\name{print.mcc_comparison}
\alias{print.mcc_comparison}
\title{Print method for MCC comparison objects}
\usage{
\method{print}{mcc_comparison}(x, ...)
}
\arguments{
\item{x}{An mcc_comparison object}

\item{...}{Additional arguments (currently unused)}
}
\value{
x invisibly
}
\description{
Print method for MCC comparison objects
}
\examples{
# Create sample data
library(dplyr)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2)
) |>
  arrange(id, time)

# Calculate MCC using different methods
mcc_eq <- mcc(df, "id", "time", "cause", method = "equation")
mcc_sci <- mcc(df, "id", "time", "cause", method = "sci")

# Compare the results
comparison <- compare_mcc(mcc_eq, mcc_sci)
print(comparison)

# Clean up
rm(df, mcc_eq, mcc_sci, comparison)

}
