% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_draws.R
\name{summarize_draws}
\alias{summarize_draws}
\title{Summarize draws}
\usage{
summarize_draws(
  draws,
  id_fields = NULL,
  draw_fields = NULL,
  ui_width = 0.95,
  na.rm = TRUE
)
}
\arguments{
\item{draws}{A \code{matrix}, \code{data.frame}, or \link[data.table:data.table]{data.table::data.table} of predictive draws.}

\item{id_fields}{(default NULL) Only considered for data.frame-like \code{draws}. What
identifier fields in the data should be kept in the summary table and not included
among the draw fields?}

\item{draw_fields}{(default NULL) Only considered for data.frame-like \code{draws}. What
fields represent actual draws, as opposed to identifier fields or other metadata like
population? If \code{NULL}, the default, automatically determines the draw fields as all
columns not included in the \code{id_fields}.}

\item{ui_width}{(\code{numeric}, default 0.95) Size of the uncertainty interval width when
calculating the upper and lower summary rasters}

\item{na.rm}{(\code{logical}, default TRUE) Should NA values be removed when calculating
summaries across draws?}
}
\value{
A \link[data.table:data.table]{data.table::data.table} containing at least the following fields:
\itemize{
\item The \code{id_fields}, if passed
\item "mean": Mean across predictive draws
\item "lower": Lower bound of the (X\%) uncertainty interval
\item "upper": Upper bound of the (X\%) uncertainty interval
\item "ui_width": "upper" - "lower"
}
}
\description{
Helper function to summarize a matrix or data.frame of predictive draws
}
\examples{
# Summarize a draws matrix
draws_matrix <- matrix(rnorm(200), nrow = 10)
summary_table_a <- summarize_draws(draws_matrix)
head(summary_table_a)

# Summarize a draws data.table with location IDs
draws_table <- matrix(c(1:10, rnorm(200)), nrow = 10) |>
  data.table::as.data.table() |>
  data.table::setnames(c('location_id', paste0('draw_', 1:20)))
summary_table_b <- summarize_draws(draws_table, id_fields = 'location_id')
head(summary_table_b)

}
\concept{prediction}
