% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spider_plot.R
\name{spider_plot}
\alias{spider_plot}
\title{Spider plot}
\usage{
spider_plot(
  data,
  data.label,
  data.fill,
  data.color,
  data.linetype,
  data.alpha,
  data.size,
  data.label.color,
  data.label.size,
  group,
  criteria,
  valor,
  title,
  title.font,
  title.color,
  title.size,
  label.font,
  label.size,
  label.color,
  label.angle,
  label.position,
  theta,
  grid,
  grid.color,
  grid.radius.color,
  grid.linetype,
  grid.size,
  grid.radius.linetype,
  grid.radius.size,
  axis,
  axis.label,
  axis.color,
  axis.size,
  axis.linetype,
  axis.angle,
  axis.label.color,
  axis.label.size,
  axis.label.displace,
  axis.label.angle,
  legend.position,
  legend.size,
  legend.text.color,
  plot.margin
)
}
\arguments{
\item{data}{data.table with the utilities of a decision model}

\item{data.label}{data label}

\item{data.fill}{data fill color}

\item{data.color}{data color}

\item{data.linetype}{line type for data}

\item{data.alpha}{alpha scale for data}

\item{data.size}{line size for data}

\item{data.label.color}{label color for data}

\item{data.label.size}{label size for data}

\item{group}{name for the column of groups}

\item{criteria}{column name for criteria}

\item{valor}{column name for utilities}

\item{title}{plot title}

\item{title.font}{font type for title}

\item{title.color}{plot title color}

\item{title.size}{plot title size}

\item{label.font}{font type for labels}

\item{label.size}{labels size}

\item{label.color}{labels color}

\item{label.angle}{labels angle}

\item{label.position}{labels position}

\item{theta}{plot rotation angle}

\item{grid}{grid for plot}

\item{grid.color}{grid color}

\item{grid.radius.color}{grid radius color}

\item{grid.linetype}{grid line type}

\item{grid.size}{grid line size}

\item{grid.radius.linetype}{grid radius line type}

\item{grid.radius.size}{grid radius line size}

\item{axis}{axis}

\item{axis.label}{axis label}

\item{axis.color}{axis color}

\item{axis.size}{axis size}

\item{axis.linetype}{axis line type}

\item{axis.angle}{axis angle}

\item{axis.label.color}{axis label color}

\item{axis.label.size}{axis label size}

\item{axis.label.displace}{axis label displacement}

\item{axis.label.angle}{axis label angel}

\item{legend.position}{label position}

\item{legend.size}{legend size}

\item{legend.text.color}{legend text color}

\item{plot.margin}{plot margin}
}
\value{
ggplot2 object with the spider plot
}
\description{
Generates an spider plot for a decision model
}
\examples{
# Preparing data
library( data.table )
library( ggplot2 )
library( mau )
n <- 27
m <- 4
cols <- sample( colors()[ grepl('(purple|blue|olive)', colors() ) ], m, replace = TRUE )

axis <- seq( 0.1, 1, 0.1 )
dat <- data.table( grp = paste( 'A', sort( rep( 1:m, n ) ), sep = '' ),
                   val = qlnorm( runif( m * n ) * plnorm( 1, 3, 4 ), 3, 4 ) )

dat <- dat[ order( grp, val ) ]
dat[ , cri := factor( rep( paste( 'c', n:1, sep = '' ), m ), 
              levels = paste( 'c', n:1, sep = '' ), ordered = TRUE ) ]
dat <- as.data.frame( dat )

parameters <- list( data = dat,
                    data.label = paste( 'A', 1:m,  ' class', sep = '' ),
                    data.fill = cols,
                    data.color = cols,
                    data.linetype = rep( 'solid', m ),
                    data.alpha = rep( 0.05, m ),
                    data.size = rep( 0.7, m ),
                    data.label.color = 'black',
                    data.label.size = 15,
                    
                    group = as.name( 'grp' ),
                    criteria = as.name( 'cri' ),
                    valor = as.name( 'val' ),
                    
                    # Spider plot parameters
                    title = 'Spider',
                    title.font = 'New Times Roman',
                    title.color = 'red3',
                    title.size = 20,
                    
                    label.font = 'New Times Roman',
                    label.size = rep( 3, n ),
                    label.color = rep( 'steelblue4', n ),
                    label.angle = rep( 0, n ),
                    label.position = rep( 1.05, n ),
                    
                    theta = pi/3,
                    
                    grid = seq( 0.1, 1, 0.1 ),
                    grid.color = 'grey75',
                    grid.radius.color = 'grey75',
                    grid.linetype = 'dashed',
                    grid.size = 0.5,
                    grid.radius.linetype = 'solid',
                    grid.radius.size = 0.5,
                    
                    axis = axis, # Same as grid
                    axis.label = paste( 100 * axis, '\%', sep = '' ),
                    axis.color = 'black',
                    axis.size = 0.7,
                    axis.linetype = 'solid',
                    axis.angle = 0.4*pi,
                    axis.label.color = 'darkgreen',
                    axis.label.size = 3,
                    axis.label.displace = -0.07,
                    axis.label.angle = 0,
                    
                    legend.position = c(0.9, 0.9),
                    legend.size = 0.5,
                    legend.text.color = 'black',
                    
                    plot.margin = unit( c( 1.0, 1.0, 1.0, 1.0 ),"cm") )


p <- do.call( spider_plot, parameters )

plot(p)
}
\author{
Pedro Guarderas, Andrés Lopez
\email{pedro.felipe.guarderas@gmail.com}
}
