% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_record.R
\name{add_record}
\alias{add_record}
\title{Add a Record to a Data Frame}
\usage{
add_record(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A data frame to which a record will be added}

\item{...}{New record to be added (vector, list, or data frame)}

\item{.before}{Optional. Row number before which to insert the new record}

\item{.after}{Optional. Row number after which to insert the new record}
}
\value{
Modified data frame with the new record inserted
}
\description{
Adds a new row to a data frame at a specified position
}
\examples{
df <- data.frame(x = 1:3, y = 4:6)
add_record(df, c(4, 7))
add_record(df, c(4, 7), .before = 2)

}
