% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHIIkindtwo.R
\name{rmatrixCHIIkind2}
\alias{rmatrixCHIIkind2}
\title{Sampler of the matrix variate type II confluent hypergeometric kind two
distribution}
\usage{
rmatrixCHIIkind2(n, nu, alpha, beta, theta = 1, p)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{nu}{shape parameter, a positive number; if \code{nu < (p-1)/2},
then \code{nu} must be a half integer}

\item{alpha, beta}{shape parameters; \code{alpha > (p-1)/2},
\code{beta < nu + 1}}

\item{theta}{scale parameter, a positive number}

\item{p}{dimension (order of the sampled matrices), an integer greater than
or equal to one}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension.
}
\description{
Samples the matrix variate type II confluent hypergeometric kind two
distribution.
}
\examples{
\donttest{
nu <- 5; alpha <- 13; beta <- 4; theta <- 2; p <- 2
sims <- rmatrixCHIIkind2(50000, nu, alpha, beta, theta, p)
# simulations of the trace
trsims <- apply(sims, 3, function(X) sum(diag(X)))
mean(trsims)
p * theta * nu * (nu+(p+1)/2-beta) / (alpha+nu+(p+1)/2-beta)}
}
\references{
A. K. Gupta & D. K. Nagar. \emph{Matrix Variate Distributions}.
Chapman & Hall/CRC, Boca Raton (2000).
}
