% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_corr_shiny.R
\name{view_corr_shiny}
\alias{view_corr_shiny}
\title{Interactive Shiny viewer for matrixCorr objects}
\usage{
view_corr_shiny(x, title = NULL, default_max_vars = 40L)
}
\arguments{
\item{x}{A correlation result, a numeric matrix, or a named list of those
objects. Each element must be square with matching row/column names.}

\item{title}{Optional character title shown at the top of the gadget.}

\item{default_max_vars}{Integer; maximum number of variables pre-selected
when the app opens. Defaults to 40 so very wide matrices start collapsed.}
}
\value{
Invisibly returns \code{NULL}; the function is called for its side
effect of launching a Shiny gadget.
}
\description{
Launches an interactive Shiny gadget that displays correlation heatmaps with
filtering, clustering, and hover inspection. The viewer accepts any
matrixCorr correlation result (for example the outputs from
\code{\link[=pearson_corr]{pearson_corr()}}, \code{\link[=spearman_rho]{spearman_rho()}}, \code{\link[=kendall_tau]{kendall_tau()}}, \code{\link[=biweight_mid_corr]{biweight_mid_corr()}},
\code{\link[=partial_correlation]{partial_correlation()}}, \code{\link[=distance_corr]{distance_corr()}}, or \code{\link[=schafer_corr]{schafer_corr()}}), a plain
matrix, or a named list of such objects. When a list is supplied the gadget
offers a picker to switch between results.
}
\details{
This helper lives in \code{Suggests}; it requires the \code{shiny} and
\code{shinyWidgets} packages at runtime and will optionally convert the plot to
an interactive widget when \code{plotly} is installed. Variable selection uses
a searchable picker, and clustering controls let you reorder variables via
hierarchical clustering on either absolute or signed correlations with a
choice of linkage methods.
}
\examples{
if (interactive()) {
  data <- mtcars
  results <- list(
    Pearson = pearson_corr(data),
    Spearman = spearman_rho(data),
    Kendall = kendall_tau(data)
  )
  view_corr_shiny(results)
}

}
