% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcc.R
\name{mcc}
\alias{mcc}
\alias{mcci}
\title{Stata-like analysis of unstratified matched-case control data}
\usage{
mcc(cases = NULL, controls = NULL, table = NULL, conf_level = 0.95)

mcci(a, b, c, d, conf_level = 0.95)
}
\arguments{
\item{cases, controls}{Numeric vectors of the same length, with values of \code{0}
(unexposed) and \code{1} (exposed). The default for these variables is \code{NULL},
and an error will be thrown if you attempt to provide these parameters as
well as \code{table}. If provided, these variables are used to construct a 2x2
matrix in the same format as \code{table}.}

\item{table}{A 2x2 integerish (see \code{checkmate::check_integerish()}) matrix
with matched case-control data. The default value of \code{table} is \code{NULL}, and
an error will be thrown if you provide \code{table} as well as \code{cases} and
\code{controls}.

The table should have the following format, where each cell represents a
pair of a matched case and control:\tabular{lll}{
   \strong{Cases} \tab \strong{Controls} \tab  \cr
    \tab Exposed \tab Unexposed \cr
   Exposed \tab a \tab b \cr
   Unexposed \tab c \tab d \cr
}}

\item{conf_level}{Numeric scalar from \code{0.1} to \code{0.9999}. Controls level at
which to calculate confidence intervals. Default = \code{0.95} (95\% confidence
intervals).}

\item{a, b, c, d}{Single integerish values with cell counts that correspond to
a 2x2 table of matched case control data.}
}
\value{
A named list with 5 elements:
\describe{
\item{\code{data}}{A 3x3 matrix generated using the data provided, formatted for
matched case-control analysis and with row/column totals.}
\item{\code{mcnemar_chi2}}{Results from analysing the matched case-control data
with \code{mcnemar.test()}, \emph{without} Yates' continuity correction.}
\item{\code{mcnemar_exact_p}}{Result of an exact test of \eqn{{H}_{0}}:
\eqn{OR = 1}, calculated using the binomial distribution.}
\item{\code{proportions}}{A two-element numeric vector with the proportion of
of cases and controls with the exposure.}
\item{\code{statistics}}{A 4 row, 3 column numeric matrix with point estimates
and confidence intervals for the ratio, difference, and relative
difference in the proportion of cases/controls with the exposure, and
the odds ratio.}
}
}
\description{
Using data from vectors, data from a 2x2 contingency table, or individual
cell counts, \code{mcc()} and \code{mcci()} will calculate McNemar's \eqn{\chi^{2}};
point estimates and confidence intervals for the difference, ratio, and
relative difference of proportion of pairs with the exposure; and the odds
ratio with a confidence interval.
}
\examples{
data <- matchedcc::mccxmpl
mcc(cases = data$case, controls = data$control)

# Convert data into 2x2 table
data$case_fctr <- factor(data$case, levels = c(1, 0),
                         labels = c("6+ cups", "0 cups"))
data$control_fctr <- factor(data$control, levels = c(1, 0),
                            labels = c("6+ cups", "0 cups"))
mcc(table = table(data$control_fctr, data$case_fctr))

# Alternatively, provide cell counts to `mcci()`
table <- table(data$control_fctr, data$case_fctr)
mcci(a = table[1,1],
     b = table[1,2],
     c = table[2,1],
     d = table[2,2])
}
\references{
Exact Chi-squared statistic:\if{html}{\out{<br>}}
McNemar, Q. (1947) \emph{Note on the sampling error of the difference between
correlated proportions or percentages} \strong{Psychometrika} 12(2): 153–157.
\doi{10.1007/bf02295996}

Other steps:\if{html}{\out{<br>}}
Agresti, A. (2013) \emph{Categorical Data Analysis} 3rd ed. Hoboken, NJ: Wiley.
pp. 414-417.
}
