% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radii.R
\name{rollup_radii_of_gyration_unc}
\alias{rollup_radii_of_gyration_unc}
\title{Roll up radii of gyration uncertainties}
\usage{
rollup_radii_of_gyration_unc(tree, df)
}
\arguments{
\item{tree}{An 'igraph' tree whose vertices are named as the values of the \code{id}
column of \code{df} and whose directed edges point from child id to parent id.}

\item{df}{A data frame  with (at least) these columns: \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint}.}
}
\value{
A data frame with the same columns as \code{df}, plus
radii of gyration in columns \code{sigma_kx}, \code{sigma_ky}, and \code{sigma_kz}.`
}
\description{
\code{rollup_radii_of_gyration_unc()} adds calculated radii of gyration uncertainties to a data frame
of rolled-up mass properties and uncertainties.

Radii of gyration uncertainties are calculated directly from moments of inertia and mass
and their uncertainties; they are not recursively-defined. Radii of gyration uncertainties
for composite elements depend on uncertainties of their component elements.
}
\examples{
sawe_table_rollup <- rollup_mass_props(sawe_tree, sawe_table)
rollup_radii_of_gyration_unc(sawe_tree, add_radii_of_gyration(sawe_table_rollup))

}
