% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcorrinhom.lpp.R
\name{mcorrinhom.lpp}
\alias{mcorrinhom.lpp}
\title{Mark correlation functions for inhomogeneous point patterns on linear networks.}
\usage{
\method{mcorrinhom}{lpp}(X,
ftype = c("variogram", "stoyan", "rcorr", "shimatani",
 "beisbart", "isham", "stoyancov", "schlather"),
r = NULL,
lambda = NULL,
method_lambda = c("kernel", "Voronoi"),
bw = bw.scott.iso,
f = NULL,
method = c("density", "loess"),
normalise = TRUE,
tol = 0.01,
...)
}
\arguments{
\item{X}{An object of class lpp.}

\item{ftype}{Type of the test function \eqn{t_f}. Currently any selection of \code{"variogram", "stoyan", "rcorr", "shimatani", "beisbart", "isham", "stoyancov", "schlather"}.}

\item{r}{Optional. The values of the argument \code{r} at which the mark correlation function should be evaluated.}

\item{lambda}{Estimated intensity at data points. If not given, it will be estimated internally. See details.}

\item{method_lambda}{The method to be used for estimating intensity at data points, if \code{lambda = NULL}.}

\item{bw}{Bandwidth method to be used for estimating intensity at data points if \code{lambda = NULL} and \code{method_lambda = "kernel"}.}

\item{f}{Optional. Test function \eqn{t_f} used in the definition of the mark correlation function. If \code{ftype} is given, \eqn{t_f} should be \code{NULL}.}

\item{method}{Type of smoothing, either \code{density} or \code{loess}.}

\item{normalise}{If \code{normalise=FALSE}, only the numerator of the expression for the mark correlation function will be computed.}

\item{tol}{Tolerance used in the calculation of the conditional mean of marks. This is used only if \code{ftype} is \code{schlather}.}

\item{...}{Arguments passed to \code{\link[spatstat.univar]{unnormdensity}} or \code{\link[stats]{loess}}.}
}
\value{
a data.frame which gives the estimated mark correlation function and the distance vector \eqn{r} at which the mark correlation function is estimated. If the point patten \eqn{X} has multiple real-valued marks, the estimated mark correlation function will be given for each mark. Name of columns will be the name of marks.
}
\description{
Mark correlation functions for inhomogeneous point patterns on linear networks.
}
\details{
Most of the details are given in \code{\link[markstat]{mcorrinhom.ppp}}. However, here distances are measured via the shortest-path distances, and intensities are estimated differently. If \code{method_lambda = "kernel"}, then the function calls
\code{\link[spatstat.linnet]{densityQuick.lpp}} in combination with the bandwidth chosen via \code{\link[spatstat.explore]{bw.scott.iso}}. If \code{method_lambda = "Voronoi"}, the functions calls
\code{\link[spatstat.linnet]{densityVoronoi.lpp}} with arguments \code{f=0.2, nrep = 400} which are recommended by Moradi et al. (2019).

In the case of point processes on linear networks, adding correction will slow down the calculations. Given that, it is argued that the type of correction does not have significant effect on the final output, we have here ignored correction terms.
We refer to Eckardt and Moradi (2024)  and Moradi and Eckardt (2025) for further details.

If the point patten \eqn{X} has multiple real-valued marks, the function estimates the mark correlation function for each mark individually. In such case, marks are given as a \code{data.frame} whose columns represents different marks. The functions checks which columns are numeric, and for those the mark correlation function will be computed.
}
\examples{
 library(spatstat.linnet)
 library(spatstat.geom)
 library(spatstat.explore)
 X <- rpoislpp(10, simplenet)
 marks(X) <- runif(npoints(X), 1, 10)
 mcorrinhom.lpp(X,  ftype = "stoyan", method = "density",
                method_lambda = "kernel", bw = bw.scott.iso)
}
\references{
Moradi, M., Cronie, O., Rubak, E., Lachieze-Rey, R., Mateu, J., & Baddeley, A. (2019). Resample-smoothing of Voronoi intensity estimators. Statistics and computing, 29(5), 995-1010.

Moradi, M., & Eckardt, M. (2025). Inhomogeneous mark correlation functions for general marked point processes. arXiv e-prints, arXiv-2505.
}
\seealso{
\code{\link[markstat]{mcorr.lpp}}, \code{\link[markstat]{mcorrinhom.ppp}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
