% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickview.R
\name{maplibre_view}
\alias{maplibre_view}
\title{Quick visualization of geometries with MapLibre GL}
\usage{
maplibre_view(
  data,
  color = "navy",
  column = NULL,
  n = NULL,
  palette = viridisLite::viridis,
  style = carto_style("positron"),
  layer_id = "quickview",
  legend = TRUE,
  legend_position = "top-left",
  interactive_legend = FALSE,
  ...
)
}
\arguments{
\item{data}{An sf object, SpatRaster, or RasterLayer to visualize}

\item{color}{The color used to visualize points, lines, or polygons if \code{column} is NULL.  Defaults to \code{"navy"}.}

\item{column}{The name of the column to visualize. If NULL (default), geometries are shown with default styling.}

\item{n}{Number of quantile breaks for numeric columns. If specified, uses step_expr() instead of interpolate().}

\item{palette}{Color palette function that takes n and returns a character vector of colors. Defaults to viridisLite::viridis.}

\item{style}{The MapLibre style to use. Defaults to carto_style("positron").}

\item{layer_id}{The layer ID to use for the visualization. Defaults to "quickview".}

\item{legend}{Logical, whether to add a legend when a column is specified. Defaults to TRUE.}

\item{legend_position}{The position of the legend on the map. Defaults to "top-left".}

\item{interactive_legend}{Logical, whether to make the legend interactive.
When TRUE, categorical legends allow clicking to toggle visibility,
and continuous legends show a range slider. Defaults to FALSE.}

\item{...}{Additional arguments passed to maplibre()}
}
\value{
A MapLibre GL map object
}
\description{
This function provides a quick way to visualize sf geometries and raster data using MapLibre GL JS.
It automatically detects the geometry type and applies appropriate styling.
}
\examples{
\dontrun{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))

# Basic view
maplibre_view(nc)

# View with column visualization
maplibre_view(nc, column = "AREA")

# View with quantile breaks
maplibre_view(nc, column = "AREA", n = 5)

# Custom palette examples
maplibre_view(nc, column = "AREA", palette = viridisLite::mako)
maplibre_view(nc, column = "AREA", palette = function(n) RColorBrewer::brewer.pal(n, "RdYlBu"))
maplibre_view(nc, column = "AREA", palette = colorRampPalette(c("red", "white", "blue")))
}
}
