% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_line.R
\name{add_line_layer}
\alias{add_line_layer}
\title{Add a line layer to the map}
\usage{
add_line_layer(map, source = NULL, filter = NULL, line_blur = NULL,
  line_cap = NULL, line_color = NULL, line_dasharray = NULL,
  line_gap_width = NULL, line_gradient = NULL, line_join = NULL,
  line_miter_limit = NULL, line_offset = NULL, line_opacity = NULL,
  line_pattern = NULL, line_round_limit = NULL, line_sort_key = NULL,
  line_translate = NULL, line_translate_anchor = NULL,
  line_width = NULL, visibility = NULL, popup = NULL,
  id = "line-layer")
}
\arguments{
\item{map}{A \link{mapboxer} object.}

\item{source}{A Mapbox source. Uses the source from the \link{mapboxer} object if no source is supplied.}

\item{filter}{A filter expression that is applied to the \code{source}.}

\item{line_blur}{(paint) Blur applied to the line, in pixels.}

\item{line_cap}{(layout) The display of line endings.
One of "butt", "round", "square".}

\item{line_color}{(paint) The color with which the line will be drawn.}

\item{line_dasharray}{(paint) Specifies the lengths of the alternating dashes
and gaps that form the dash pattern.}

\item{line_gap_width}{(paint) Draws a line casing outside of a line's actual path.
The value indicates the width of the inner gap.}

\item{line_gradient}{(paint) Defines a gradient with which to color a line feature.
Can only be used with GeoJSON sources that specify \code{lineMetrics = TRUE}.}

\item{line_join}{(layout) The display of lines when joining.
One of "bevel", "round", "miter".}

\item{line_miter_limit}{(layout) Used to automatically convert miter joins to bevel joins for sharp angles.
Requires \code{line_join} to be "miter".}

\item{line_offset}{(paint) The line's offset.
For linear features, a positive value offsets the line to the right,
relative to the direction of the line, and a negative value to the left.
For polygon features, a positive value results in an inset, and a negative value results in an outset.}

\item{line_opacity}{(paint) The opacity at which the line will be drawn.}

\item{line_pattern}{(paint) Name of image in sprite to use for drawing image lines.}

\item{line_round_limit}{(layout) Used to automatically convert round joins to miter joins for shallow angles.}

\item{line_sort_key}{(layout) Sorts features in ascending order based on this value.
Features with a higher sort key will appear above features with a lower sort key.}

\item{line_translate}{(paint) The geometry's offset. Values are [x, y] where negatives indicate left and up, respectively.}

\item{line_translate_anchor}{(paint) Controls the frame of reference for \code{line_translate}.}

\item{line_width}{(paint) Stroke thickness.}

\item{visibility}{(layout) Whether the layer should be displayed.}

\item{popup}{A \href{https://github.com/janl/mustache.js}{mustache} template
in which the tags refer to the properties of the layer's data object.}

\item{id}{The unique id of the layer.}
}
\description{
Add a line layer to the map
}
\examples{
map <-  as_mapbox_source(geojsonsf::geo_melbourne) \%>\%
  mapboxer(
    center = c(144.9624, -37.8105),
    zoom = 11,
    pitch = 45
  ) \%>\%
  add_navigation_control() \%>\%
  add_line_layer(
    line_color = c("get", "strokeColor"),
    line_width = 2,
    popup = "{{SA2_NAME}}"
  )

if (interactive()) map
}
\seealso{
\url{https://docs.mapbox.com/mapbox-gl-js/style-spec/layers/#line}
}
