% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stehman2014.R
\name{stehman2014}
\alias{stehman2014}
\title{Thematic map accuracy and area under stratified random sampling when the strata differ from 
the map classes.}
\usage{
stehman2014(s, r, m, Nh_strata, margins = TRUE, order)
}
\arguments{
\item{s}{character vector. Strata class labels. The object will be coerced to factor.}

\item{r}{character vector. Reference class labels. The object will be coerced to factor.}

\item{m}{character vector. Map class labels. The object will be coerced to factor.}

\item{Nh_strata}{numeric vector. Number of pixels forming each stratum. It must be named (see details).}

\item{margins}{logical. If \code{FALSE}, the error matrix produced includes no margins (sum of the 
rows and columns).}

\item{order}{(optional) character vector. Classes to be displayed in the results and their sequence.
If missing, equal to \code{sort(unique(c(r,m)))}.}
}
\value{
A list with the estimates and error matrix.
\item{OA}{overall accuracy}
\item{UA}{user's accuracy}
\item{PA}{producer's accuracy}
\item{area}{area proportion}
\item{SEoa}{standard error of OA}
\item{SEua}{standard error of UA}
\item{SEpa}{standard error of PA}
\item{SEa}{standard error of area proportion}
\item{matrix}{confusion error (area proportion). Rows and columns represent map and reference class labels, respectively}
}
\description{
Implements the estimators described in Stehman (2014) for overall accuracy, producer's 
accuracy, user's accuracy, and area. Includes precision estimates.
}
\details{
Argument \code{Nh_strata} must be named to explicitly and clearly identify the stratum that 
each entry refers to. The names of \code{Nh_strata} are expected to match the strata class 
labels of argument \code{s}.

In the error matrix returned, the entries corresponding to no observed cases will present
\code{NA} rather than 0. This is to emphasize the difference between the absence of cases
and the presence of some (few) cases that represent a very small proportion of area (almost
zero) and thus possibly rounded to zero. However, \code{NA} means zero proportion of area.
}
\examples{
# Numerical example in Stheman (2014)
s<-c(rep("A",10), rep("B",10), rep("C",10), rep("D",10))
m<-c(rep("A",7), rep("B",3), "A", rep("B",11), rep("C",6), "B", "B", rep("D",10))
r<-c(rep("A",5), "C", "B", "A", "B", "C", "A", rep("B",5), "A", "A", "B", 
     "B", rep("C",5), "D", "D", "B", "B", "A", rep("D",7), "C", "C", "B")
Nh_strata<-c(40000, 30000, 20000, 10000)
names(Nh_strata)<-c("A", "B", "C", "D")
e<-stehman2014(s, r, m, Nh_strata)

e$area[1]                  # Proportion of area of class A (compare with paper in p. 4932)
e$area[3]                  # Proportion of area of class C (p. 4932)
e$OA                       # Overall accuracy (p. 4932)
e$UA[2]                    # User's accuracy of class B (compare with paper in p. 4934)
e$PA[2]                    # Producer's accuracy of class B (p. 4934)
e$matrix[2,3]              # Cell (2, 3) of the error matrix (p. 4935)
e$SEa[1]                   # Standard error (SE) for proportion of area of class A (p. 4935)
e$SEa[3]                   # Standard error (SE) for proportion of area of class C (p. 4935)
e$SEoa                     # SE for overall accuracy (p. 4936)
e$SEua[2]                  # SE for user's accuracy of class B (p. 4936)
e$SEpa[2]                  # SE for producer's accuracy of class B (p. 4936)

# change class order
stehman2014(s, r, m, Nh_strata, order=c("D","C","B","A"))

# the number (and name) of strata and map classes may differ
s<-c(rep("a",5), rep("aa",5), rep("b",10), rep("c",10), rep("d",10))
Nh_strata<-c("a"=20000, "aa"=20000, "b"=30000, "c"=20000, "d"=10000)
stehman2014(s, r, m, Nh_strata)

# m (map) may include classes not found in r (reference)
m<-c(rep("A",7), rep("B",3), "A", rep("B",11), rep("C",6), "B", "B", rep("D",9), "XX")
stehman2014(s, r, m, Nh_strata)

# r (reference) may include classes not found in m (map)
m<-c(rep("A",7), rep("B",3), "A", rep("B",11), rep("C",6), "B", "B", rep("D",10))
r<-c(rep("A",5), "C", "B", "A", "B", "C", "A", rep("B",5), "A", "A", "B",
     "B", rep("C",5), "D", "D", "B", "B", "A", rep("D",7), "C", "C", "YY")
stehman2014(s, r, m, Nh_strata)

# can add classes not found neither in r nor m
stehman2014(s, r, m, Nh_strata, order=c("A","B","C","D","YY","ZZ"))
}
\references{
Stehman, S. V. (2014). Estimating area and map accuracy for stratified random sampling when the strata are different from the map classes. \emph{Int. J. Remote Sens.}, 35, 4923-4939.
}
\author{
Hugo Costa
}
