% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_functions.R
\name{run_builtin_analysis}
\alias{run_builtin_analysis}
\title{Complete Manureshed Analysis Workflow (Built-in Data)}
\usage{
run_builtin_analysis(
  scale = "huc8",
  year = 2016,
  nutrients = c("nitrogen", "phosphorus"),
  output_dir = tempdir(),
  include_wwtp = TRUE,
  wwtp_year = NULL,
  custom_wwtp_nitrogen = NULL,
  custom_wwtp_phosphorus = NULL,
  wwtp_column_mapping = NULL,
  wwtp_skip_rows = 0,
  wwtp_header_row = 1,
  wwtp_load_units = "kg",
  add_texas = FALSE,
  save_outputs = TRUE,
  cropland_threshold = NULL,
  verbose = TRUE
)
}
\arguments{
\item{scale}{Character. Spatial scale: "county", "huc8", or "huc2"}

\item{year}{Numeric. Year to analyze (available: start-2016 for NuGIS, 2016 for built-in WWTP)}

\item{nutrients}{Character vector. Nutrients to analyze: c("nitrogen", "phosphorus") or subset}

\item{output_dir}{Character. Output directory for results (default: "manureshed_results")}

\item{include_wwtp}{Logical. Whether to include WWTP analysis (default: TRUE)}

\item{wwtp_year}{Numeric. Year for WWTP data (default: same as year, only 2016 available built-in)}

\item{custom_wwtp_nitrogen}{Character. Path to custom WWTP nitrogen file (for non-2016 years)}

\item{custom_wwtp_phosphorus}{Character. Path to custom WWTP phosphorus file (for non-2016 years)}

\item{wwtp_column_mapping}{Named list. Custom column mapping for WWTP data}

\item{wwtp_skip_rows}{Numeric. Rows to skip in custom WWTP files (default: 0)}

\item{wwtp_header_row}{Numeric. Header row in custom WWTP files (default: 1)}

\item{wwtp_load_units}{Character. Units of WWTP loads: "kg", "lbs", "pounds", "tons" (default: "kg")}

\item{add_texas}{Logical. Whether to add Texas HUC8 data (only for HUC8 scale, default: FALSE)}

\item{save_outputs}{Logical. Whether to save results to files (default: TRUE)}

\item{cropland_threshold}{Numeric. Custom cropland threshold for exclusion (optional)}

\item{verbose}{Logical. Whether to print detailed progress messages (default: TRUE)}
}
\value{
List with all analysis results for specified nutrients
}
\description{
Run complete manureshed analysis using built-in NuGIS data (start-2016)
and optional WWTP data. For WWTP analysis beyond 2016, users must provide their own data.
Supports analysis of nitrogen, phosphorus, or both nutrients simultaneously.
}
\examples{
\donttest{
# Basic analysis using built-in data (2007-2016 WWTP available)
results_2016 <- run_builtin_analysis(
  scale = "huc8",
  year = 2016,
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = TRUE
)

# Analysis for earlier year (no WWTP available) - nitrogen only
results_2010 <- run_builtin_analysis(
  scale = "county",
  year = 2010,
  nutrients = "nitrogen",
  include_wwtp = FALSE
)

# Analysis for earlier year with WWTP now available
results_2010 <- run_builtin_analysis(
  scale = "county",
  year = 2010,
  nutrients = "nitrogen",
  include_wwtp = TRUE  # Now supported for 2010!
)

# Analysis for year before WWTP availability
results_2005 <- run_builtin_analysis(
  scale = "huc8",
  year = 2005,
  nutrients = "phosphorus",
  include_wwtp = FALSE  # No WWTP data before 2007
)
}
}
