/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ViterbiWriter
extends TransducerEvaluator {
    String filenamePrefix;
    String outputEncoding = "UTF-8";

    public ViterbiWriter(String filenamePrefix, InstanceList[] instanceLists, String[] descriptions) {
        super(instanceLists, descriptions);
        this.filenamePrefix = filenamePrefix;
    }

    public ViterbiWriter(String filenamePrefix, InstanceList instanceList1, String description1) {
        this(filenamePrefix, new InstanceList[]{instanceList1}, new String[]{description1});
    }

    public ViterbiWriter(String filenamePrefix, InstanceList instanceList1, String description1, InstanceList instanceList2, String description2) {
        this(filenamePrefix, new InstanceList[]{instanceList1, instanceList2}, new String[]{description1, description2});
    }

    public ViterbiWriter(String filenamePrefix, InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, InstanceList instanceList3, String description3) {
        this(filenamePrefix, new InstanceList[]{instanceList1, instanceList2, instanceList3}, new String[]{description1, description2, description3});
    }

    @Override
    protected void preamble(TransducerTrainer tt) {
    }

    @Override
    public void evaluateInstanceList(TransducerTrainer transducerTrainer, InstanceList instances, String description) {
        PrintStream viterbiOutputStream;
        int iteration = transducerTrainer.getIteration();
        String viterbiFilename = this.filenamePrefix + description + iteration + ".viterbi";
        try {
            FileOutputStream fos = new FileOutputStream(viterbiFilename);
            viterbiOutputStream = this.outputEncoding == null ? new PrintStream(fos) : new PrintStream((OutputStream)fos, true, this.outputEncoding);
        }
        catch (IOException e) {
            System.err.println("Couldn't open Viterbi output file '" + viterbiFilename + "'; continuing without Viterbi output trace.");
            return;
        }
        for (int i = 0; i < instances.size(); ++i) {
            if (viterbiOutputStream != null) {
                viterbiOutputStream.println("Viterbi path for " + description + " instance #" + i);
            }
            Instance instance = (Instance)instances.get(i);
            Sequence input = (Sequence)instance.getData();
            TokenSequence sourceTokenSequence = null;
            if (instance.getSource() instanceof TokenSequence) {
                sourceTokenSequence = (TokenSequence)instance.getSource();
            }
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = transducerTrainer.getTransducer().transduce(input);
            assert (predOutput.size() == trueOutput.size());
            for (int j = 0; j < trueOutput.size(); ++j) {
                FeatureVector fv = (FeatureVector)input.get(j);
                if (sourceTokenSequence != null) {
                    viterbiOutputStream.print(((Token)sourceTokenSequence.get(j)).getText() + ": ");
                }
                viterbiOutputStream.println(trueOutput.get(j).toString() + '/' + predOutput.get(j).toString() + "  " + fv.toString(true));
            }
        }
    }
}

