% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{coint_maki}
\alias{coint_maki}
\title{Maki Cointegration Test with Structural Breaks}
\usage{
coint_maki(y, m = 1, model = 0, trimm = 0.15, lagoption = 1)
}
\arguments{
\item{y}{Matrix or data frame with dependent variable in first column and
independent variable(s) in remaining columns.}

\item{m}{Maximum number of breaks to test (0-3). Values 4-5 require extended implementation.}

\item{model}{Model specification (0-3):
\itemize{
  \item 0: Level shift
  \item 1: Level shift with trend  
  \item 2: Regime shift (changes in intercept and slope)
  \item 3: Trend and regime shift
}}

\item{trimm}{Trimming parameter (default 0.15). Determines the minimum 
distance between breaks as a fraction of sample size.}

\item{lagoption}{Lag selection (0=no lags, 1=optimal lags using t-sig criterion).}
}
\value{
A list with class "maki_test" containing:
  \item{statistic}{The test statistic (minimum tau)}
  \item{breakpoints}{Vector of detected break point locations}
  \item{critical_values}{Critical values at 1\%, 5\%, and 10\% levels}
  \item{reject_1}{Logical; reject null at 1\% level?}
  \item{reject_5}{Logical; reject null at 5\% level?}
  \item{reject_10}{Logical; reject null at 10\% level?}
  \item{conclusion}{Text conclusion of the test}
  \item{m}{Number of breaks tested}
  \item{model}{Model specification used}
  \item{n}{Sample size}
}
\description{
Performs the Maki (2012) cointegration test that allows for an unknown 
number of structural breaks. The test detects cointegration relationships
in the presence of up to five structural breaks.
}
\examples{
# Generate cointegrated series with one break
set.seed(123)
n <- 100
e1 <- rnorm(n)
e2 <- rnorm(n)
x <- cumsum(e1)
y <- 0.5 * x + cumsum(e2)
y[51:100] <- y[51:100] + 2  # Add structural break

# Run Maki test
data <- cbind(y, x)
result <- coint_maki(data, m=1, model=0)
print(result)
}
\references{
Maki, D. (2012). Tests for cointegration allowing for an unknown number
of breaks. \emph{Economic Modelling}, 29(5), 2011-2015.
}
