% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_r_smooth_layer_processor.R
\name{BaseRSmoothLayerProcessor}
\alias{BaseRSmoothLayerProcessor}
\title{Base R Smooth/Density Layer Processor}
\description{
Processes Base R smooth curves including:
- Density plots: plot(density()) or lines(density())
- Loess smooth: lines(loess.smooth()) or lines(predict(loess))
- Smooth splines: lines(smooth.spline())
}
\keyword{internal}
\section{Super class}{
\code{\link[maidr:LayerProcessor]{maidr::LayerProcessor}} -> \code{BaseRSmoothLayerProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BaseRSmoothLayerProcessor-process}{\code{BaseRSmoothLayerProcessor$process()}}
\item \href{#method-BaseRSmoothLayerProcessor-extract_data}{\code{BaseRSmoothLayerProcessor$extract_data()}}
\item \href{#method-BaseRSmoothLayerProcessor-generate_selectors}{\code{BaseRSmoothLayerProcessor$generate_selectors()}}
\item \href{#method-BaseRSmoothLayerProcessor-find_polyline_grobs}{\code{BaseRSmoothLayerProcessor$find_polyline_grobs()}}
\item \href{#method-BaseRSmoothLayerProcessor-generate_selectors_from_grob}{\code{BaseRSmoothLayerProcessor$generate_selectors_from_grob()}}
\item \href{#method-BaseRSmoothLayerProcessor-extract_axis_titles}{\code{BaseRSmoothLayerProcessor$extract_axis_titles()}}
\item \href{#method-BaseRSmoothLayerProcessor-extract_main_title}{\code{BaseRSmoothLayerProcessor$extract_main_title()}}
\item \href{#method-BaseRSmoothLayerProcessor-clone}{\code{BaseRSmoothLayerProcessor$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="apply_scale_mapping"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-apply_scale_mapping'><code>maidr::LayerProcessor$apply_scale_mapping()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="extract_layer_axes"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-extract_layer_axes'><code>maidr::LayerProcessor$extract_layer_axes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_last_result'><code>maidr::LayerProcessor$get_last_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_layer_index"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_layer_index'><code>maidr::LayerProcessor$get_layer_index()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="initialize"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-initialize'><code>maidr::LayerProcessor$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="needs_reordering"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-needs_reordering'><code>maidr::LayerProcessor$needs_reordering()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="reorder_layer_data"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-reorder_layer_data'><code>maidr::LayerProcessor$reorder_layer_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="set_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-set_last_result'><code>maidr::LayerProcessor$set_last_result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-process"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-process}{}}}
\subsection{Method \code{process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$process(
  plot,
  layout,
  built = NULL,
  gt = NULL,
  scale_mapping = NULL,
  grob_id = NULL,
  panel_id = NULL,
  panel_ctx = NULL,
  layer_info = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-extract_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-extract_data}{}}}
\subsection{Method \code{extract_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$extract_data(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-generate_selectors"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-generate_selectors}{}}}
\subsection{Method \code{generate_selectors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$generate_selectors(layer_info, gt = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-find_polyline_grobs"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-find_polyline_grobs}{}}}
\subsection{Method \code{find_polyline_grobs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$find_polyline_grobs(grob, call_index = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-generate_selectors_from_grob"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-generate_selectors_from_grob}{}}}
\subsection{Method \code{generate_selectors_from_grob()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$generate_selectors_from_grob(grob, call_index = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-extract_axis_titles"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-extract_axis_titles}{}}}
\subsection{Method \code{extract_axis_titles()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$extract_axis_titles(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-extract_main_title"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-extract_main_title}{}}}
\subsection{Method \code{extract_main_title()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$extract_main_title(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRSmoothLayerProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRSmoothLayerProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRSmoothLayerProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
