% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-helper.R
\name{survfit_makeup}
\alias{survfit_makeup}
\title{Helper function to select set of variables used for Kaplan-Meier plot}
\usage{
survfit_makeup(km_fit, single_trt_name = "treatment")
}
\arguments{
\item{km_fit}{returned object from \code{survival::survfit}}

\item{single_trt_name}{name of treatment if no strata are specified in \code{km_fit}}
}
\value{
a list of data frames of variables from \code{\link[survival:survfit]{survival::survfit()}}. Data frame is divided by treatment.
}
\description{
Helper function to select set of variables used for Kaplan-Meier plot
}
\examples{
library(survival)
data(adtte_sat)
data(pseudo_ipd_sat)
combined_data <- rbind(adtte_sat[, c("TIME", "EVENT", "ARM")], pseudo_ipd_sat)
kmobj <- survfit(Surv(TIME, EVENT) ~ ARM, combined_data, conf.type = "log-log")
survfit_makeup(kmobj)
}
