% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{check_weights}
\alias{check_weights}
\alias{print.maicplus_check_weights}
\title{Check to see if weights are optimized correctly}
\usage{
check_weights(weighted_data, processed_agd)

\method{print}{maicplus_check_weights}(
  x,
  mean_digits = 2,
  prop_digits = 2,
  sd_digits = 3,
  digits = getOption("digits"),
  ...
)
}
\arguments{
\item{weighted_data}{object returned after calculating weights using \code{\link{estimate_weights}}}

\item{processed_agd}{a data frame, object returned after using \code{\link{process_agd}} or
aggregated data following the same naming convention}

\item{x}{object from \link{check_weights}}

\item{mean_digits}{number of digits for rounding mean columns in the output}

\item{prop_digits}{number of digits for rounding proportion columns in the output}

\item{sd_digits}{number of digits for rounding mean columns in the output}

\item{digits}{minimal number of significant digits, see \link{print.default}.}

\item{...}{further arguments to \link{print.data.frame}}
}
\value{
data.frame of weighted and unweighted covariate averages of the IPD,
average of aggregate data, and sum of inner products of covariate \eqn{x_i} and the weights (\eqn{exp(x_i\beta)})
}
\description{
This function checks to see if the optimization is done properly
by checking the covariate averages before and after adjustment.
In case of ties when calculating median,
we return the mean of the two numbers. For more details,
see \code{ties} parameter in \link[matrixStats:weightedMedian]{matrixStats::weightedMedian}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(maicplus_check_weights)}: Print method for check_weights objects

}}
\examples{
data(weighted_sat)
data(agd)
check_weights(weighted_sat, process_agd(agd))
}
