% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{coalesce}
\alias{coalesce}
\title{Return first non-missing element}
\usage{
coalesce(..., nan = NA)
}
\arguments{
\item{...}{vectors}

\item{nan}{NA or NaN. For details see \link[data.table:coalesce]{fcoalesce}}
}
\value{
A vector the same length as the first ... argument with NA
values replaced by the first non-missing value.
}
\description{
It is an alias for data.table \code{fcoalesce}. For details see \link[data.table:coalesce]{fcoalesce}
}
\examples{
# examples from dplyr
x = sample(c(1:5, NA, NA, NA))
coalesce(x, 0L)

y = c(1, 2, NA, NA, 5)
z = c(NA, NA, 3, 4, 5)
coalesce(y, z)
}
