% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_chord_diagram.R
\name{plot_chord_diagram}
\alias{plot_chord_diagram}
\title{plot the Macro-synteny as a chord diagram}
\usage{
plot_chord_diagram(
  orthologs_df,
  species_labels = NULL,
  species_labels_size = 5,
  color_by = "sp1.Chr",
  custom_color_palette = NULL,
  reorder_chromosomes = TRUE,
  remove_non_linkage_orthologs = TRUE,
  species_labels_hpos = -400,
  label_size = 2,
  ideogram_fill = "white",
  ideogram_color = "black",
  ideogram_height = 4,
  ribbons_curvature = 0.1,
  ribbons_alpha = 0.5
)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded by the load_orthologs()}

\item{species_labels}{list of characters. names of the species to display on the plot}

\item{species_labels_size}{integer. size of the labels (default = 2)}

\item{color_by}{string. name of the column in the orthologs_df to color the links by (default = "sp1.Chr")}

\item{custom_color_palette}{list of characters. palette to use for the coloring of the links following the argument color_by}

\item{reorder_chromosomes}{logical. (default = TRUE) tells whether to reorder the chromosomes in clusters as implemented in reorder_macrosynteny()}

\item{remove_non_linkage_orthologs}{logical. (default = TRUE) tells wether to remove the orthologs that are not within significant linkage groups as calculated by comput_linkage_groups().}

\item{species_labels_hpos}{(default =-400)}

\item{label_size}{integer. size of the labels to display on the ideograms (default = 2)}

\item{ideogram_fill}{character. name of the colors to fill the ideograms with (default = "white")}

\item{ideogram_color}{character. name of the colors to draw the borders of the ideograms with (default = "black")}

\item{ideogram_height}{integer. height of the ideograms (default = 4)}

\item{ribbons_curvature}{float. curvature of the ribbons (default = 0.1)}

\item{ribbons_alpha}{float. alpha of the ribbons (default = 0.5)}
}
\value{
A ggplot2 object
}
\description{
This is a function to plot the chord diagrams to compare the macro synteny of two or more species.
It requires as input an orthologs_df loaded by load_orthologs()
}
\examples{
# basic usage of plot_oxford_grid : 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)

plot_chord_diagram(my_orthologs,species_labels = c("B. flo","P. ech"))

}
\seealso{
\code{\link[=load_orthologs]{load_orthologs()}}

\code{\link[=reorder_macrosynteny]{reorder_macrosynteny()}}

\code{\link[=compute_linkage_groups]{compute_linkage_groups()}}
}
