% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{replace}
\alias{replace}
\title{Change contents of an existing variable}
\usage{
replace(data, var, value, ...)
}
\arguments{
\item{data}{data.frame}

\item{var}{variable}

\item{value}{value for replacement}

\item{...}{\code{if} conditions or expressions}
}
\value{
data.frame
}
\description{
\code{replace()} alters the contents of a variable when specified
conditions are met.
}
\details{
If only \code{value} is specified, the whole variable is assigned
with the \code{value}. Multiple conditions can be specified within
the three dots.
}
\examples{

x <- replace(infert, case, 2, case == 0)
tab(x, case)

x <- replace(infert, parity, 4, parity > 4)
tab(x, parity)

\dontrun{
## More examples
## replacing mpg with standardized values of mpg
replace(mtcars, mpg, mpg / mean(mpg))

## replacing mpg with NA if < 10 or > 20
replace(mtcars, mpg, NA, mpg < 10 | mpg > 20)

## replacing education levels with one value
replace(infert, education, "6+yrs",
        education == "6-11yrs" | education == "12+ yrs")

## replacing mpg with NA if mpg is from 10 and 20.
replace(mtcars, mpg, NA, mpg >= 10, mpg <= 20)
}

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
