% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_summaries.R
\name{asb.sp.summary}
\alias{asb.sp.summary}
\title{Summarize Assemblage x Species data frame}
\usage{
asb.sp.summary(asb_sp_w)
}
\arguments{
\item{asb_sp_w}{a matrix showing assemblages (rows) composition in species
(columns). Note that species names \strong{must be} the names of rows.}
}
\value{
A list with:
\item{asb_sp_w_occ}{a matrix with species occurrences in each
assemblage.}
\item{sp_tot_w}{a vector gathering species biomass/abundance per
species.}
\item{asb_tot_w}{a vector gathering total abundance/biomass per
assemblage.}
\item{asb_sp_richn}{a vector gathering species richness per
assemblage.}
\item{asb_sp_nm}{a list gathering the names of species of each
assemblage.}
}
\description{
This function computes a summary helping you to picture assemblages. For
this function to work, there must be no NA in your \code{asb_sp_w} data frame.
}
\examples{
# Load Assemblages x Species Matrix
data('baskets_fruits_weights', package = 'mFD')

# Summarize Assemblages Data
mFD::asb.sp.summary(asb_sp_w = baskets_fruits_weights)
}
\author{
Camille Magneville and Sebastien Villeger
}
