% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.R
\name{jackknife}
\alias{jackknife}
\title{Generate replicates of a dataset using Jackknife}
\usage{
jackknife(data, weight_cols = "none", drop = TRUE)
}
\arguments{
\item{data}{dataset}

\item{weight_cols}{vector of weight columns}

\item{drop}{if \code{TRUE}, the observation that will not be part of the subsample is dropped from the dataset. Otherwise, it stays in the dataset but a new weight column is created to differentiate the selected observations}
}
\value{
a list containing all the Jackknife replicates of \code{data}
}
\description{
Generate replicates of a dataset using Jackknife
}
\examples{
x <- data.frame(
    number = 1:5,
    letter = LETTERS[1:5],
    stringsAsFactors = FALSE
)
jackknife(x)
jackknife(x, drop = FALSE)
}
\seealso{
\code{\link[=brr]{brr()}}
}
