% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_gen_together.R
\name{cluster_gen_together}
\alias{cluster_gen_together}
\title{Generate cluster samples with lowest-level questionnaires}
\usage{
cluster_gen_together(
  n_levels,
  n,
  N,
  sum_pop,
  calc_weights,
  sampling_method,
  cluster_labels,
  resp_labels,
  collapse,
  n_X,
  n_W,
  cat_prop,
  c_mean,
  sigma,
  cor_matrix,
  rho,
  verbose,
  ...
)
}
\arguments{
\item{n_levels}{number of cluster levels}

\item{n}{numeric vector or list with the number of sampled observations (clusters or subjects) on each level}

\item{N}{population size of each \emph{sampled} cluster element on each level. Either a numeric vector or a list of numeric vectors. If \code{N} is a list, it must have the same length as \code{n} and each element of \code{N} must have the same length as the corresponding element of \code{n}}

\item{sum_pop}{total population at each level (sampled or not)}

\item{calc_weights}{if \code{TRUE}, sampling weights are calculated}

\item{sampling_method}{can be "SRS" for Simple Random Sampling, "PPS" for Probabilities Proportional to Size, "mixed" to use PPS for schools and SRS otherwise, or a vector with the sampling method for each level}

\item{cluster_labels}{character vector with the names of each cluster level}

\item{resp_labels}{character vector with the names of the questionnaire respondents on each level}

\item{collapse}{if \code{TRUE}, function output contains only one data frame with all answers. It can also be "none", "partial" and "full" for finer control on 3+ levels}

\item{n_X}{list of \code{n_X} per cluster level}

\item{n_W}{list of \code{n_W} per cluster level}

\item{cat_prop}{list of cumulative proportions for each item. If \code{theta
  = TRUE}, the first element of \code{cat_prop} must be a scalar 1, which
corresponds to the \code{theta}.}

\item{c_mean}{vector of means for the continuous variables or list of vectors for the continuous variables for each level}

\item{sigma}{vector of standard deviations for the continuous variables or list of vectors for the continuous variables for each level}

\item{cor_matrix}{correlation matrix or list of correlation matrices per PSU}

\item{rho}{intraclass correlation (scalar, vector or list, as appropriate)}

\item{verbose}{if \code{TRUE}, prints output messages}

\item{...}{Additional parameters to be passed to \code{questionnaire_gen()}}
}
\description{
This is a sub-function of \code{cluster_gen} that performs cluster sampling where only the lowest-level individuals (e.g. students) fill out questionnaires.
}
\seealso{
\code{\link[=cluster_gen]{cluster_gen()}} \code{\link[=cluster_gen_separate]{cluster_gen_separate()}}
}
