% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticPCA.R
\name{logisticPCA}
\alias{logisticPCA}
\title{Logistic Principal Component Analysis}
\usage{
logisticPCA(x, k = 2, m = 4, quiet = TRUE, partial_decomp = FALSE,
  max_iters = 1000, conv_criteria = 1e-05, random_start = FALSE, start_U,
  start_mu, main_effects = TRUE, validation, M, use_irlba)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{k}{number of principal components to return}

\item{m}{value to approximate the saturated model. If \code{m = 0}, m is solved for}

\item{quiet}{logical; whether the calculation should give feedback}

\item{partial_decomp}{logical; if \code{TRUE}, the function uses the rARPACK package
to more quickly calculate the eigen-decomposition. This is usually faster than standard
eigen-decomponsition when \code{ncol(x) > 100} and \code{k} is small}

\item{max_iters}{number of maximum iterations}

\item{conv_criteria}{convergence criteria. The difference between average deviance
in successive iterations}

\item{random_start}{logical; whether to randomly inititalize the parameters. If \code{FALSE},
function will use an eigen-decomposition as starting value}

\item{start_U}{starting value for the orthogonal matrix}

\item{start_mu}{starting value for mu. Only used if \code{main_effects = TRUE}}

\item{main_effects}{logical; whether to include main effects in the model}

\item{validation}{optional validation matrix. If supplied and \code{m = 0}, the
validation data is used to solve for \code{m}}

\item{M}{depricated. Use \code{m} instead}

\item{use_irlba}{depricated. Use \code{partial_decomp} instead}
}
\value{
An S3 object of class \code{lpca} which is a list with the
following components:
\item{mu}{the main effects}
\item{U}{a \code{k}-dimentional orthonormal matrix with the loadings}
\item{PCs}{the princial component scores}
\item{m}{the parameter inputed or solved for}
\item{iters}{number of iterations required for convergence}
\item{loss_trace}{the trace of the average negative log likelihood of the algorithm.
   Should be non-increasing}
\item{prop_deviance_expl}{the proportion of deviance explained by this model.
   If \code{main_effects = TRUE}, the null model is just the main effects, otherwise
   the null model estimates 0 for all natural parameters.}
}
\description{
Dimensionality reduction for binary data by extending Pearson's
PCA formulation to minimize Binomial deviance
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run logistic PCA on it
lpca = logisticPCA(mat, k = 1, m = 4, main_effects = FALSE)

# Logistic PCA likely does a better job finding latent features
# than standard PCA
plot(svd(mat_logit)$u[, 1], lpca$PCs[, 1])
plot(svd(mat_logit)$u[, 1], svd(mat)$u[, 1])
}
\references{
Landgraf, A.J. & Lee, Y., 2015. Dimensionality reduction for binary data through 
the projection of natural parameters. arXiv preprint arXiv:1510.06112.
}

