% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localboot.R
\name{localboot}
\alias{localboot}
\title{Local Bootstrap for Network Data}
\usage{
localboot(
  A,
  B,
  quantile_n = 0,
  returns = "boot",
  method = "own",
  dist_func = get_dist_default_eigen,
  kowning_u = NULL,
  induced_sampling = TRUE,
  weighted = FALSE,
  getT = NULL,
  user_blist = NULL,
  fast = NULL,
  ...
)
}
\arguments{
\item{A}{A square adjacency matrix of the network.}

\item{B}{The number of bootstrap samples to generate.}

\item{quantile_n}{The quantile used for neighborhood selection in some methods.
If set to 0 (default), it's calculated as (log(N) / N)^0.5.}

\item{returns}{Specifies the type of output returned. Possible values are 
"boot" (default), "p_and_time", "p_and_boot", and "T".}

\item{method}{The method used for bootstrapping. Options are "own" and "zhu".}

\item{dist_func}{A function to compute the distance matrix. Default is 
`get_dist_default_eigen`.}

\item{kowning_u}{An optional known 'u' vector for distance calculation.}

\item{induced_sampling}{A logical indicating whether to use induced sampling.
Defaults to TRUE.}

\item{weighted}{A logical indicating if the network is weighted. Defaults to FALSE.}

\item{getT}{An optional function to apply to each bootstrapped sample.}

\item{user_blist}{An optional user-provided bootstrap list.}

\item{fast}{A logical indicating if a faster, approximate method should be used. 
Automatically set based on network size if NULL.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
Depending on the `returns` argument, this function can return various types 
    of outputs including bootstrapped networks, estimated probabilities, computation 
    times, and statistics from the `getT` function.
}
\description{
This function applies a local bootstrap method to network data, represented 
by an adjacency matrix. It offers various methods and options for bootstrapping,
including handling weighted networks and custom distance functions.
}
\examples{
# Example usage
P = generate_graphon(100, 1)
A = generate_network_P(P, replicate = 1, symmetric.out = TRUE)
result <- localboot(A = A, B = 100, returns = "boot")

}
